public class Hitset {


    /**Here are some sets defined in connection with the hitset.
       The hitset is the orbit of the union of the following 2
       pieces.*/

    public static PolygonWrapper hitsetLo(double P,int i,int j) {
	double[][] d={{3-3*P,1-2*P},{3-P,1},{1+P,1+P},{1-P,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }


    public static PolygonWrapper hitsetHi(double P,int i,int j) {
	double[][] d={{P-1,P-1},{1-P,-1},{3-3*P,1-2*P},{1-P,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }




    public static PolygonWrapper hitset(double P,int i,int j) {
	double[][] d={{P-1,P-1},{1-P,-1},{3-P,1},{1+P,1+P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }









}


