import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class MathRational {
    public int p;  //numerator
     public int q;  //denominator

    public MathRational(int p,int q) {
	this.p=p;
	this.q=q;
    }

    public MathRational(MathRational R) {
	this.p=R.p;
	this.q=R.q;
    }

    public MathRational() {}

    public void print() {
	System.out.println(p+"/"+q);
    }


    /*This first routine implements the extended Euclidean algorithm.
      This is to say that program takes integers a,b and finds not
      only g=gcd(a,b) but also integers c,d such that ac+bd=g.  I 
      originally had programmed my own version of the Euclidean algorithm,
      but I lifted this algorithm from the internet.  The algorithm is
      taken from Donald Knuth's book of algorithms.*/


public static int[] GCDe(int a,int b) {

  int u,v,g;
  int u1,v1,g1;
  int t1,t2,t3;
  int q;
  u  = 1;  
  v  = 0;  
  g  = a;
  u1 = 0;  
  v1 = 1;  
  g1 = b;
  while (g1 != 0) {
    q = g/g1; 
    t1 = u - q*u1;   
    t2 = v - q*v1;   
    t3 = g - q*g1;
    u  = u1;   
    v  = v1;    
    g  = g1;
    u1 = t1;    
    v1 = t2;    
    g1 = t3;
  }
  int[] x={u,v,g};
  return(x);
}

    /*This just computes the greatest common divisor, without the coefficients.*/

    public static int GCD(int a,int b) {
	int[] x=GCDe(a,b);
	return(x[2]);
    }


    public static MathRational reduce(MathRational F) {
	int k=GCD(F.p,F.q);
	MathRational G=new MathRational(F.p/k,F.q/k);
	return(G);
    }

    public static int[] reduce(int a,int b) {
	int c=GCD(a,b);
	int[] d={a/c,b/c};
	return(d);
    }

    /**When k=1 this returns widehat tau from
       the monograph*/

    public static int tune(int p,int q,int k) {
	for(int i=0;i<p+q;++i) {
	    int test=2*p*i%(p+q);
	    if(test==k) return(i);
	}
	return(0);
    }

    public static int slant(int p,int q,int k) {
	int n=p+q;
	for(int i=0;i<n;++i) {
	    int test=(2*p*i+n)%(2*n);
	    if(test>n) test=test-(2*n);
	    if(test==k) return(i);
	}
	return(0);
    }

    /**converts to the Truchet parameter*/

    public static int[] getTruchet(int p,int q) {
	int q0=2*p;
	int p0=p+q;
	while(p0>q0) p0=p0-q0;
	int p1=q0-p0;
	if(p1<p0) p0=p1;
	int[] m={p0,q0};
	return m;
    }



    /***extra debugging stuff******/


    public static int[] RMINUS(int a,int b) {

	if(a==1) {
	    int[] x={0,1};
	    return(x);
	}

	int[] d=GCDe(a,b);
	d[1]=-d[1];
	int t=(int)(Math.floor(1.0*d[0]/b));
	d[0]=d[0]-t*b;
	d[1]=d[1]-t*a;
	int[] e={d[1],d[0]};
	return(e);
    }


    public static int[] RPLUS(int a,int b) {

	int[] x = RMINUS(a,b);
	int[] y={a-x[0],b-x[1]};
	return(y);
    }

    //for even rationals

    public static int[] evenPredecessor(int a,int b) {
	if(a==1) {
	    int[] X={a,b};
	    return(X);
	}
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test=(d1[0]*d1[1])%2;
	if(test==1) return(d2);
	return(d1);
    }

    /** 
      -1: trivial case of p=1 
       0: weak case
       1: strong case
       3: core case
    **/

    public static int classify(int p,int q) {
	if(p==1) return(-1);
	int t=tune(p,q);
	if(t<(2.0/8)*(p+q)) return(0);
	if(3*t>p+q) return(2);
	return(1);
    }

    public static int[] corePredecessor(int a,int b) {
	if(a==1) {
	    int[] A={a,b};
	    return(A);
	}
	int k=kappa(a,b);
	int[] A=evenPredecessor(a,b);
	int[] B={a-2*k*A[0],b-2*k*A[1]};
	return(B);
    }

    public static int[] predecessor(int p,int q) {
	int c=classify(p,q);
	int[] A={0,1};
	if(c==-1) return(A);
	if(c!=2) return evenPredecessor(p,q);
	return(corePredecessor(p,q));
    }

    /**The tuning routines*/

    public static int tune(int p,int q) {
	int a1=tune(p,q,1);
	int a2=p+q-a1;
	if(a1<a2) return a1;
	return a2;
    }



    /**This returns the odd version of the tune*/

    public static int superTune(int p,int q) {
	int a1=tune(p,q,1);
	int a2=tune(p,q,2);
	int a3=p+q-a1;
	int a4=p+q-a2;
	int t=a1;
	if(t>a2) t=a2;
	if(t>a3) t=a3;
	if(t>a4) t=a4;
	return(t);
    }


    /**this is kappa from the monograph*/
    public static int kappa(int p,int q) {
	int t0=tune(p,q);
	double t=1.0*t0/(p+q);
	double n=Math.floor(1/(1.0/t-2));
	int N=(int)(n);
	return(N);
    }





}
