import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Parameter {
    int x,y;
    String HISTORY;
    boolean ACTIVE;
    ListenSquare MAIN,TEXT,INFO;
    ListenSquare RANDOM;
    Color COLOR;
    String S;

    public Parameter(int xx,int yy,String s) {
	this.x=xx;
	this.y=yy;
	this.S=s;
	TEXT=new ListenSquare(x,y,400,40);
	ACTIVE=false;
	COLOR=Color.blue;
	MAIN=new ListenSquare(x,y,415,40);
	RANDOM=new ListenSquare(x,y+20,50,18);
	INFO=new ListenSquare(x+88,y,12,12);
	HISTORY="";
    }

    public String toString(int a,int b) {
	Integer A=new Integer(a);
	Integer B=new Integer(b);
	String S=A.toString()+"/"+B.toString();
	return(S);
    }

    public void render(Graphics2D g) {	
        drawBG(g,60);
	renderTau(g);
	RANDOM.render(g,new Color(0,0,150));
	g.setColor(Color.white);
	g.drawString("random",(int)(RANDOM.x+5),(int)(RANDOM.y+13));
	INFO.infoRender(g); 
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString(S,x+5,y+15);
    }


    public void renderTau(Graphics2D g) {
	int p=getNumerator();
	int q=getDenominator();
	Integer OMEGA=new Integer(p+q);
	int tau_hat=MathRational.tune(p,q,1);
	int tau=tau_hat;
	Integer TAU_HAT=new Integer(tau_hat);
	String TU1="\u03C4="+TAU_HAT.toString();
	String OME="\u03C9="+OMEGA.toString();
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString(TU1,x+5,y+55);
	g.drawString(OME,x+52,y+55);
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(x+3,y+46);
	gp.lineTo(x+7,y+42);
	gp.lineTo(x+11,y+46);
	g.draw(gp);
    }

    public void drawBG(Graphics2D g,int n) {
	g.setColor(Color.blue);
	g.fillRect(x,y,100,n);
	g.setColor(Color.white);
	g.drawRect(x,y,100,n);
    }

    public void activate(Point X) {
	ACTIVE=false;
	if(TEXT.inside(X)==1) ACTIVE=true;
    }


    public int[] interpretFraction() {
	return(interpretFraction(S));
    }

    public int[] interpretFraction(String U) {
	int k=U.indexOf("/");
	if(k==-1) {
	    U=U.replace(" ","");
	    Integer I=new Integer(U);
	    int[] a={I.intValue(),1};
	    return(a);
	}
	String T1=U.substring(0,k);
	String T2=U.substring(k+1,U.length());
	Integer I1=new Integer(T1);
	Integer I2=new Integer(T2);
	int[] I={I1.intValue(),I2.intValue()};
	return(I);
    }

    public int countChar(String T,char x) {
	int count=0;
	int n=T.length();
	for(int i=0;i<n;++i) {
	    char ch=T.charAt(i);
	    if(ch==x) ++count;
	}
	return(count);
    }

    public boolean acceptFraction(int[] b) {
	long[] c={b[0],b[1]};
	acceptFraction(c);
	return(true);
    }

    public boolean acceptFraction(long[] b) {
	if(b[0]<=0) return(false);
	if(b[1]<=0) return(false);
	Long b0=new Long(b[0]);
	Long b1=new Long(b[1]);
	S=b0.toString()+"/"+b1.toString();
	return(true);
    }

    public void reduce() {
	int[] x=interpretFraction();
        int s=MathRational.GCD(x[0],x[1]);
	x[0]=x[0]/s;
	x[1]=x[1]/s;
	acceptFraction(x);
    }



    /**random selector*/
    public void getRandom() {
	int[] a=random();
	Integer A0=new Integer(a[0]);
	Integer A1=new Integer(a[1]);
	S=A0.toString()+"/"+A1.toString();
	return;
    }

    public int[] random() {
	boolean test=false;
	int[] a={};
	int max=32;
	int min=2;
	int diff=2;
	try{
           max=ParameterControl.B[0];
           min=ParameterControl.B[1];
           diff=ParameterControl.B[2];
	}
	catch(Exception e) {}

	while(test==false) {
	   int c=1+(int)(max*Math.random());
	   int b=1+(int)(Math.min(c,max*Math.random()));  
           a=MathRational.reduce(b,c);
           if((a[0]>=min)&&(a[1]-a[0]>=diff)&&(a[0]*a[1]%2==0)) test=true;
	}
	return(a);
    }
    /**end random selector*/



    /**get the parameter*/

    public double getParameter() {
       int[] b=interpretFraction();
       double y=1.0*b[0]/b[1]; 
       return(y);
    }

    public int getNumerator() {
	int[] a=getFraction();
	return(a[0]);
    }

    public int getDenominator() {
	int[] a=getFraction();
	return(a[1]);
    }

    public int[] getFraction() {
	int[] a={1,2};
	try {
	   a=interpretFraction();
	}
	catch(Exception e) {}
	return(a);
    }
    /**end get-parameter routines*/


    /**testing whether the selector is used*/

    public boolean inside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(MAIN.inside(J.X)==1) return(true);
	return(false);
    }

    public boolean inside(Point X) {
	if(MAIN.inside(X)==1) return(true);
	return(false);
    }




    public void process(MouseEvent e,Manager M) {
	MouseData J=MouseData.process(e);
	activate(J.X);
  	if(RANDOM.inside(J.X)==1) getRandom();
	if(INFO.inside(J.X)==1) DocumentControl.parameter(M.D);
	reduce();
    }

    public boolean processKey(KeyEvent e) {
	if(ACTIVE==false) return(false);
	int n=S.length();

	char ch=e.getKeyChar();

        if(isDigit(ch)==true) S=S+ch;

	int val=0;
	val=(int)(ch-'/');
	if(val==0) S=S+"/";

	val=(int)(ch-'+');
	if(val==0) S=S+"+";

	val=(int)(ch-'-');
	if(val==0) S=S+"-";

	val=(int)(ch-' ');
	if(val==0) S=S+" ";


        if (ch==KeyEvent.VK_BACK_SPACE) {
	    if(n>0) S=S.substring(0,n-1);
        }

        if (ch==KeyEvent.VK_DELETE) {
            S="1/2";
        }
	if(S.length()>50) S=S.substring(0,n-1);
	return(true);

    }

    public boolean isDigit(char ch) {
        int val=(int)(ch-'0');
        if ((val>=0)&&(val<=9)) {
	    return(true);
	}
	return(false);
    }


}





