import java.awt.*;
import java.math.*;
import java.awt.geom.*;
import java.util.Arrays;

public class Particle {

    /**This class tracks the horizontal particles in the plaid model*/

    public static double horizontalNextP(int p,int q,double x) {
	int a=tau(p,q);
	double P=2.0*p/(p+q);
	double y=x+a*(p+q)+1/P;
	return(y);
    }

    public static double verticalNextP(int p,int q,double x) {
	int a=tau(p,q);
	double P=2.0*p/(p+q);
	double y=x+a*(p+q);
	return(y);
    }

    public static double horizontalNextQ(int p,int q,double x) {
	int a=tau(p,q);
	double Q=2.0*q/(p+q);
	double y=x+a*(p+q)-1/Q;
	return(y);
    }

    /**This gets the variable -widehat tau from the monograph*/
    public static int tau(int p,int q) {
	for(int i=0;i<p+q;++i) {
	    int test=2*p*i%(p+q);
	    if(test==p+q-1) return(i);
	}
	return(0);
    }

    /**This renders a random choice of horizontal particle*/

    public static void drawHorizontalParticle(Graphics2D g,Manager M) {
	Path2D.Double gp=new Path2D.Double();	
	int p=M.C.PAR.getNumerator();
	int q=M.C.PAR.getDenominator();
	double A=1.0*p/q;
	Complex z=new Complex(0,0);
	int y=getRandom(p,q);
	Complex c=new Complex();
	    int lim=0;
	    for(int choice=0;choice<2;++choice) {
	         if(choice==0) lim=2*p;
	         if(choice==1) lim=2*q;
	         for(int i=0;i<lim;++i) {
	  	  c.x=Math.floor(z.x)+.5;
		  c.y=Math.floor(z.y)+.5; 
 	          Vector4 V=PlaidClassifyingMap.PHI(A,c.x,c.y);
	          gp=makeSquare(p,q,V.x[0],V.x[1]);
	          gp=M.Q.transform(gp);
	          g.setColor(Color.red);  
                  g.fill(gp);
	          g.setColor(Color.white);
	          g.draw(gp);
		  if(choice==0) z.x=Particle.horizontalNextP(p,q,z.x);
		  if(choice==1) z.x=Particle.horizontalNextQ(p,q,z.x);
		  z.y=y;
		  if(i%2==1) z.y=y-(p+q);
		 }
	    }
    }


    public static void drawVerticalParticle(Graphics2D g,Manager M) {
	Path2D.Double gp=new Path2D.Double();	
	int p=M.C.PAR.getNumerator();
	int q=M.C.PAR.getDenominator();	
        double A=1.0*p/q;
	Complex z=new Complex(getRandom(p,q),.5);
	Complex c=new Complex();
	    int lim=p+q;
	    for(int choice=0;choice<2;++choice) {
	         for(int i=0;i<lim;++i) {
	  	  c.x=Math.floor(z.x)+.5;
		  double y=z.y;
		  if((i+choice)%2==1) y=y-(p+q);
		  c.y=Math.floor(y)+.5;
 	          Vector4 V=PlaidClassifyingMap.PHI(A,c.x,c.y);
	          gp=makeSquare(p,q,V.x[1],V.x[2]);
	          gp=M.Q.transform(gp);
	          g.setColor(Color.red);  
                  g.fill(gp);
	          g.setColor(Color.white);
	          g.draw(gp);
		  if(choice==0) z.y=z.y+1;
		  if(choice==1) z.y=z.y-1;
		  z.x=verticalNextP(p,q,z.x);
		 }
	    }
    }



    public static int getRandom(int p,int q) {
	int w=p+q;
	int r=(int)(w*Math.random());
	return r;
    }

    public static Path2D.Double makeSquare(int p,int q,double x0,double x1) {
	Path2D.Double gp=new Path2D.Double();
	double y=1.0/(p+q);
	gp.moveTo(x0-y,x1-y);
	gp.lineTo(x0+y,x1-y);
	gp.lineTo(x0+y,x1+y);
	gp.lineTo(x0-y,x1+y);
	gp.closePath();
	return(gp);
    }




}

