import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Color[] COLOR=new Color[7];
    Output OUT;
    Point JX;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(0,400,400.0/11);	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);


      int p=M.p();
      int q=M.q();
      if((p*q)%2==1) return;
      if(p>=q) return;
      if(p<1) return;


      /**square grid*/
      if(M.C.MODEL.L[2].on==1) { 
	drawTiles(g,0);
      }

      /**pixel failure*/
      if(M.C.AG.L[3].on==1) {
	  AGPlot.drawPixelFail(M,g);
      }

      /**hexagrid lines*/
      if(M.C.MODEL.L[5].on==1) { 
	  try{drawHexagridPartial(g);}
	  catch(Exception e) {}
      }

      /**plaid polygons*/
      if(M.C.MODEL.L[0].on==1) {
	  drawTiles(g,1);
      }
      /**first polygon*/
      if(M.C.MODEL.L[1].on==1) {
	  drawFirst(g);
      }
      /**tracer*/
      if(M.C.MODEL.L[3].on==1) {
	  drawTracer(g);
      }
      /**oriented tiles*/
      if(M.C.MODEL.L[9].on==1) {
        drawTilesEnhanced(g);
      }

      /**negatively sloped slant lines*/
      if(M.C.MODEL.L[5].on==1) {
	  drawSlantLines(g,0,-1,M.C.MODEL.M[5].C);
      }

      /**positively sloped slant lines*/
      if(M.C.MODEL.L[6].on==1) {
	  drawSlantLines(g,0,1,M.C.MODEL.M[6].C);
      }

      /**positively sloped slant lines*/
      if(M.C.MODEL.L[7].on==1) {
	  if(M.C.MODEL.L[5].on==1)
	  drawSlantLines(g,1,-1,M.C.MODEL.M[7].C);
	  if(M.C.MODEL.L[6].on==1)
	  drawSlantLines(g,1,+1,M.C.MODEL.M[7].C);
      }


      /**light points*/
      if(M.C.MODEL.L[4].on==1) {
	  drawLightPoints(g);
      }



      /**hexagrid lines*/
      if(M.C.MODEL.L[8].on==1) { 
	  try{drawHexagridPartial(g);}
	  catch(Exception e) {}
      }

      if(M.C.AG.L[2].on==1) {
	  AGPlot.drawAGLattice(M,g);
      }

      if(M.C.AG.L[0].on==1) {
	  AGPlot.blockPlot(M,g);
      }

      if(M.C.AG.L[1].on==1) {
	  AGPlot.firstPolygon(M,g,true);
      }

      if(M.C.AG.L[4].on==1) {
	  AGPlot.firstPolygon(M,g,false);
      }

      if(M.C.AG.L[5].on==1) {
	  AGPlot.nearestGrid(M,g);
      }


      drawSource(g);
      drawFrame(g);
   }




    /**this draws the source point*/

    public void drawSource(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(SOURCE.x,SOURCE.y);
	gp.lineTo(SOURCE.x,SOURCE.y);
	gp=transform(gp);
	g.setColor(Color.white);
	g.setStroke(new BasicStroke(5));
	g.fill(gp);
	g.draw(gp);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(2));
	g.fill(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,0));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }




    public int getBlockNumber() {
	int p=M.p();
	int q=M.q();
	int a=MathRational.tune(p,q,p+q-1);
	int omega=p+q;
	int NUM=M.C.SCA.S.val;
	int n=(NUM*a)%(2*omega);
	return n;
    }

    public int[] getLimits() {
	int p=M.p();
	int q=M.q();
	int a=MathRational.tune(p,q,p+q-1);
	int omega=p+q;
	int NUM=M.C.SCA.S.val;
	int n=(NUM*a)%(2*omega);
	int[] L={n*omega,n*omega+omega};
	return(L);
    }


    public void drawFrame(Graphics2D g) {
        Path2D.Double gp=getFrame();
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }

    public Path2D.Double getFrame() {
	int p=M.p();
	int q=M.q();
	int w=p+q;
	double x0=w*Math.floor(SOURCE.x/w);
	double y0=w*Math.floor(SOURCE.y/w);
        Path2D.Double gp=new Path2D.Double();
	gp.moveTo(x0,y0);
	gp.lineTo(x0,y0+w);
	gp.lineTo(x0+w,y0+w);
	gp.lineTo(x0+w,y0);
	gp.closePath();
	return gp;
    }



    public Path2D.Double getLittleFrame(int k) {
	double t=k+.5;
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(SOURCE.x-t,SOURCE.y-t);
	gp.lineTo(SOURCE.x-t,SOURCE.y+t);
	gp.lineTo(SOURCE.x+t,SOURCE.y+t);
	gp.lineTo(SOURCE.x+t,SOURCE.y-t);
	gp.closePath();
	return(gp);
    }


    public void drawSlantLines(Graphics2D g,int choice,int sign,Color C) {
	int p=M.p();
	int q=M.q();
	if(p+q>200) return;
	int[] L=getLimits();
	Tile T=new Tile();
	Path2D.Double gp=new Path2D.Double();
 	int cap=M.C.CAPACITY.mode;
	int cap2=M.C.CAPACITY2.val;

	for(int i=L[0];i<L[1];++i) {
	    for(int j=L[0]-L[1];j<(L[1]-L[0]);++j) {
		T=new Tile(p,q,i,j);

		if(cap==0) {
                    gp=T.getLines(choice,sign);
		    gp=transform(gp);
		}
		if(cap==1) {
                    gp=T.getLinesLimited(choice,sign,cap2);
		    gp=transform(gp);
		}
		if(choice==1) {
		   g.setColor(Color.black);
		   g.fill(gp);
		}
		g.setColor(C);
	        g.draw(gp);
	    }

	}
    }







    public void drawLightPoints(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	if(p+q>200) return;
	int[] L=getLimits();
	Tile T=new Tile();
	Path2D.Double gp=new Path2D.Double();
	int cap=M.C.CAPACITY.mode;
	int cap2=M.C.CAPACITY2.val;

	for(int i=L[0];i<L[1];++i) {
	    for(int j=L[0]-L[1];j<(L[1]-L[0]);++j) {
		T=new Tile(p,q,i,j);
		gp=T.getPointPath();
		if(cap==1) gp=T.getPointPathLimited(cap2);
		gp=transform(gp);
		g.setColor(M.C.MODEL.M[4].C);
		g.setStroke(new BasicStroke(4));
		g.draw(gp);
		g.setStroke(new BasicStroke(1));
	    }
	}
    }



    public void drawTiles(Graphics2D g,int mode) {
	int p=M.p();
	int q=M.q();
	if(p+q>200) return;
	int k=p+q;
	int[] L=getLimits();
	Tile T=new Tile();
	Path2D.Double gp=new Path2D.Double();
	Path2D.Double gp2=new Path2D.Double();

	for(int i=L[0];i<L[1];++i) {
	    for(int j=-(L[1]-L[0]);j<(L[1]-L[0]);++j) {
		T=new Tile(p,q,i,j);
		int cap=M.C.CAPACITY.mode;
		int cap2=M.C.CAPACITY2.val;

		//just the squares
		if((mode==0)&&(cap==0)) {
		  gp=T.getSquare();
		  gp=transform(gp);
		  g.setColor(M.C.MODEL.M[2].C);
		  g.draw(gp);
		}

		if((mode==0)&&(cap==1)) {
		  gp=T.getSquare();
		  gp2=T.getSquareLimited(cap2);
		  gp2=transform(gp2);
		  gp=transform(gp);
		  g.setColor(new Color(30,30,30));
		  g.draw(gp);
		  g.setColor(M.C.MODEL.M[2].C);
		  g.draw(gp2);
		}


		//main mode
		if(mode==1) { 
		    int style=M.C.DRAWSTYLE.mode;
                    T.type();
		    if(T.type!=0) {
		      gp=T.getTileUndirected(style);
		      gp=transform(gp);
		      g.setColor(M.C.MODEL.M[0].C);
		      g.draw(gp);
		    }
		}
	    }
	}
    }

    public void drawFirst(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int t=MathRational.tune(p,q,1);
	drawTracer(g,0,t,M.C.MODEL.M[1].C);
    }


    public void drawTracer(Graphics2D g) {
	int i=(int)(Math.floor(SOURCE.x));
	int j=(int)(Math.floor(SOURCE.y));
	drawTracer(g,i,j,M.C.MODEL.M[3].C);
    }


    public void drawTracer(Graphics2D g,int i,int j,Color C) {
	int p=M.p();
	int q=M.q();
	Tile T=new Tile(p,q,i,j);
	Path2D.Double gp=TileTracer.plaidPolygon(T);
	gp=transform(gp);
	g.setColor(C);
	g.setStroke(new BasicStroke(2));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }


    public void locate(int k) {
	double x=A[0].getTranslateX();
	double y=A[0].getTranslateY();
	int p=M.p();
	int q=M.q();
	double s=A[1].getScaleX();
	double x1=s*k;
	A[0]=AffineTransform.getTranslateInstance(x-x1,y);
	SOURCE.x=SOURCE.x+k;
    }

    public void drawTilesEnhanced(Graphics2D g) {
        int p=M.p();
	int q=M.q();
	if(p+q>200) return;
	Tile T=new Tile();
	double P=2.0*p/(p+q);
	int[] L=getLimits();
	Path2D.Double gp=new Path2D.Double();

	for(int i=L[0];i<L[1];++i) {
	    for(int j=L[0]-L[1];j<(L[1]-L[0]);++j) {
    	        T=new Tile(p,q,i,j);
		int[] I=PlaidClassifyFast.classify(T);
		gp=T.getSquare();
	        gp=transform(gp);

		if(I!=null) {
		    g.setColor(PlaidPETColors.getColor(I[0],I[1]));
		    g.fill(gp);
		    g.setColor(Color.white);
		    g.draw(gp);
              
		}

		if(I!=null) {
		if(I[0]!=I[1]) {
  	          gp=T.getEdgeDirected(I[0],I[1]);
		  gp=transform(gp);
	  	  g.setColor(M.C.MODEL.M[9].C);
		  g.fill(gp);
		  g.draw(gp);
		}}
	    }
	}
    }

    public void sendPoint(int p,int q,Complex Z) {
	sendPointPlaid(p,q,Z);
	sendPointGraph(p,q,Z);
    }

    public void sendPointPlaid(int p,int q,Complex Z) {
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	Vector4 V=PlaidClassifyingMap.PHI(A,Z.x,Z.y);
	try{
	  int mode=M.QS.DIRECTION.mode;
          M.QS.PAR=P;
	  M.QS.S[mode]=V.x[mode];
	  if(mode==0) M.Q.SOURCE=new Complex(V.x[1],V.x[2]);
	  if(mode==1) M.Q.SOURCE=new Complex(V.x[0],V.x[2]);
	  if(mode==2) M.Q.SOURCE=new Complex(V.x[0],V.x[1]);  
	}
	catch(Exception e) {} 
    }

    public void sendPointGraph(int p,int q,Complex Z) {
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	Complex w=AGLattice.nearestGrid(p,q,Z);
	if(w==null) return;
        w=AGTransforms.p2kAffine(p,q,w);
	int m=(int)(Math.floor(w.x+.5));
	int n=(int)(Math.floor(w.y+.5));
	Vector4 X=AGMap.PSI(p,q,m,n);
	try{	 
           int mode=M.GS.DIRECTION.mode;
           M.GS.PAR=1.0*p/q;
	   M.GS.S[mode]=X.x[mode];
	   if(mode==0) M.G.SOURCE=new Complex(X.x[1],X.x[2]);
	   if(mode==1) M.G.SOURCE=new Complex(X.x[0],X.x[2]);
	   if(mode==2) M.G.SOURCE=new Complex(X.x[0],X.x[1]);  
	}
	catch(Exception e) {}
    }


    public void drawHexagridPartial(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int a=MathRational.tune(p,q,p+q-1);
	int[] L=getLimits();
	Path2D.Double gp=new Path2D.Double();

	for(int i=0;i<16;++i) {
	  for(int j=0;j<6;++j) {
	    if(M.H.Z[j].L[i].on==1) {
		if(j==0) gp=M.H.getH(p,q,L,i);
		if(j==1) gp=M.H.getV(p,q,L,i);
		if(j>=2) gp=M.H.getSlant(j-2,p,q,L,i);
                Color C=M.H.Z[j].M[i].C;
		gp=transform(gp);
	        g.setColor(C);
	        g.draw(gp);
	    }
	  }
	}

	for(int j=0;j<6;++j) {
	    if(M.H.EXTRA[j].on==1) {
		int sign=M.H.SIGN[j].val;
		int weight=M.H.WEIGHT[j].val/2;
		int tot=2*weight+sign;
	        if(j==0) gp=M.H.getH(p,q,L,tot);
		if(j==1) gp=M.H.getV(p,q,L,tot);
		if(j>=2) gp=M.H.getSlant(j-2,p,q,L,tot);
                Color C=Color.white;
		gp=transform(gp);
	        g.setColor(C);
	        g.draw(gp);
	    }
	}
    }


    public void setSource(Point X) {
       SOURCE=unTransform(X);
       try{M.ST.Z=new Complex(SOURCE);}
       catch(Exception e) {}
       try{M.CU.Z=new Complex(SOURCE);}
       catch(Exception e) {}
       int p=M.p();
       int q=M.q(); 
       SOURCE.x=Math.floor(SOURCE.x)+.50000001;
       SOURCE.y=Math.floor(SOURCE.y)+.50000001;
       sendPoint(p,q,SOURCE);
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  setSource(JX);
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
         MouseData J=MouseData.process(e);
	 JX=J.X;
     }
  
     public void mouseDragged(MouseEvent e) {
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}





}

