import java.awt.*;
import java.math.*;


public class PlaidClassifyingMap {


    /**This is the map Phi from the monograph.  this maps
       the A-slice into the P-slice*/

    public static Vector4 PHI(double A,double x,double y) {
	double P=2*A/(1+A);
	double[] U=affineMap(P,x,y);
	U=reduce(P,U);
	Vector4 V=new Vector4(U[0],U[1],U[2],U[3]);
	return V;
    }

    public static double[] affineMap(double P,double x, double y) {
	double a1=2*P*x+2*y;
	double a2=2*P*x;
	double a3=2*P*x+2*P*y;
	double[] X={P,a1,a2,a3};
	return(X);
    }


    /**WARNING: these routines have to be used carefully
       because they switch around the first and last coordinate.*/

    public static Vector4 reduce(Vector4 V) {
	double[] U={V.x[0],V.x[1],V.x[2],V.x[3]};
	U=reduce(U);
	Vector4 W=new Vector4(U[0],U[1],U[2],U[3]);
	return W;
    }
    public static double[] reduce(double[] U) {
	double[] V={U[3],U[0],U[1],U[2]};
	return reduce(V[0],V);
    }

    /**The parameter is the last coordinate.*/

    public static double[] reduce(double P,double[] u) {
	double x=u[1]/4;
	x=Math.floor(x+.5);
	x=4*x;
	double[] v={0,0,0,0};
	v[0]=u[1]-x;
	v[1]=u[2]-x*P/2;
	v[2]=u[3]-x*P/2;
	v[1]=dec2(v[1]);
	v[2]=dec2(v[2]);
	v[3]=u[0];
	return(v);
    }

    public static double dec1(double x) {
	return(x-Math.floor(x));
    }
    /**range is [-1,1]*/

    public static double dec2(double x) {
	double y1=x/2.0+1/2.0;
	double y2=dec1(y1);
	double y3=2*y2-1;
	return(y3);
    }
}

