import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class PlaidGraphCommunication {

    /**This file lets you take a point on the plaid PET
       and send it to a corresponding point on the graph PET.
       It does the same thing for the polytopes in the
       triple partition*/


    public static void sendPoint(Manager M,Complex z) { 
	try{
	    Vector4 V1=getPointPlaid(M,z);
            Vector4 V2=PlaidToGraph.omega(V1);
	    sendPointGraph(M,V2);
	}
       catch(Exception e) {}
    }


    public static Vector4 getPointPlaid(Manager M,Complex z) {  
       int mode=M.QS.DIRECTION.mode;
       double t=M.QS.getSlice();
       double P=M.QS.getParameter();
       Vector4 V=new Vector4();
       if(mode==0) V=new Vector4(t,z.x,z.y,P);
       if(mode==1) V=new Vector4(z.x,t,z.y,P);
       if(mode==2) V=new Vector4(z.x,z.y,t,P);
       return V;

    }

    public static void sendPointGraph(Manager M,Vector4 X) {
       int mode=M.GS.DIRECTION.mode;
       M.GS.PAR=X.x[3];
       M.GS.S[mode]=X.x[mode];
       if(mode==0) M.G.SOURCE=new Complex(X.x[1],X.x[2]);
       if(mode==1) M.G.SOURCE=new Complex(X.x[0],X.x[2]);
       if(mode==2) M.G.SOURCE=new Complex(X.x[0],X.x[1]);  
    }



 }