import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PlaidPETCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Color[] COLOR=new Color[7];
    Point JX;
    ControlPanel SLOPE;
    int INDEX;

    public PlaidPETCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(200,200,180);
	 INDEX=-1;	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);

      /**These are the main drawing routines*/

      if(M.C.PLAID.L[0].on==1) { 
          int dyn=M.QS.getDynamics();
	  drawPartition(dyn,g); 
	  drawImage(g);
      }

      if(M.C.PLAID.L[1].on==1) {
	  cleanPartition(g);
          drawImage(g);
      }

      if(M.C.PLAID.L[2].on==1) {
	  ZPiece(0,g);
      }

      if(M.C.PLAID.L[3].on==1) {
	  ZPiece(1,g);
      }

      if(M.C.PLAID.L[4].on==1) {
	  ZPiece(2,g);
      }

      if(M.C.PLAID.L[5].on==1) {
	  ZPiece(3,g);
      }

      if(M.C.PLAID.L[6].on==1) {
	  ZTiling(g,0);
	  ZTiling(g,1);
      }

      if(M.C.PLAID.L[7].on==1) {
	  hitset(0,g);
      }

      if(M.C.PLAID.L[8].on==1) {
	  hitset(1,g);
      }

      if(M.C.PLAID.L[9].on==1) {
	  hitset(2,g);
      }

      if(M.C.PLAID.L[10].on==1) {
	  drawReminder(g);
      }




      /**These are sanity checks*/

      if(M.C.SANITY.L[0].on==1) {
	  SanityCheck1.drawClassMap(g,this.M);
       }

      if(M.C.SANITY.L[1].on==1) {
	  M.C.WAL.draw(g,this);
      }

      if(M.C.SANITY.L[2].on==1) {
	  Particle.drawVerticalParticle(g,this.M);
      }

      if(M.C.SANITY.L[3].on==1) {
	  Particle.drawHorizontalParticle(g,this.M);
      }

      if(M.C.SANITY.L[4].on==1) {
	  SanityCheck2.plotHitset(g,this.M);
       }

   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,0));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }


    /**This shows the oriented tile picked by the
       neutral partition. */

    public void drawReminder(Graphics2D g) {
	if(M.QS.DYNAMICS.mode!=0) return;
	Vector4 V=PlaidGraphCommunication.getPointPlaid(M,SOURCE);
	V=PlaidClassifyingMap.reduce(V);
	int[] I=PlaidClassifyFast.plaidType(V);
	g.setColor(PlaidPETColors.getColor(I[0],I[1]));
	g.fillRect(0,0,50,50);
	g.setColor(Color.white);
	g.drawRect(0,0,50,50);
	if(I[0]==I[1]) return;
	AffineTransform AFF0=AffineTransform.getScaleInstance(50,-50);
	AffineTransform AFF1=AffineTransform.getTranslateInstance(0,50);
	Path2D.Double gp=Tile.getEdgeDirected(I[0],I[1],0,0);
	gp.transform(AFF0);
	gp.transform(AFF1);
	g.setColor(Color.white);
	g.fill(gp);
    }

    /**this draws the image under the classifying map.*/

    public void drawImage(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(SOURCE.x,SOURCE.y);
	gp.lineTo(SOURCE.x,SOURCE.y);
	gp=transform(gp);
	g.setColor(Color.white);
	g.setStroke(new BasicStroke(6));
	g.fill(gp);
	g.draw(gp);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(3));
	g.fill(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }



    /**These routines draw the polytope partition*/

    public void fillPoly(Graphics2D g,Path2D.Double gp,Color C) {
       gp=transform(gp);
       g.setColor(C);
       g.fill(gp);  
       g.setColor(Color.white);
       g.draw(gp);
    }

    /**This is for displaying the polytope vertices*/
    public void polyInfo(Path2D.Double gp,int q1,int q2,int q3,int k) {

	if(gp.contains(SOURCE.x,SOURCE.y)==true) {
	    try{   
		int[] ty=DataPlaidPolytopes.type(k);
		if((q1+10)%2==1) {
		    int a=ty[1];
		    ty[1]=ty[0];
		    ty[0]=a;
		}
                int[] S={q1,q2,q3,ty[0],ty[1]};
		int[] LIST={1};
		M.I.LIST=LIST;
		M.I.POLY[1]=k;
		M.I.DATA=S;
	    }
	    catch(Exception e) {
	    }
	}
    }


    /**This draws the plaid
       PET partition.  The variable dyn says whether we
       take the neutral, forward, or backward
       partition*/

    public void drawPartition(int dyn,Graphics2D g) {
	int lim1=-2;
	int lim2=2;
	int s=0;
	double t=0;
	double P=1/2;

	try{
	    lim1=-M.QS.TILE.val;
	    lim2=+M.QS.TILE.val;  
            s=M.QS.DIRECTION.mode;   
            t=M.QS.getSlice();
	    t=t+.000001;
	    P=M.QS.getParameter();
	}
	catch(Exception e) {}

	for(int i=0;i<26;++i) {  
            Polytope POLY0=AllPolytopes.plaid(i);

	    for(int a1=lim1;a1<=lim2;++a1) {
	        for(int a2=lim1;a2<=lim2;++a2) {
		   for(int a3=lim1;a3<=lim2;++a3) {
       
	              Polytope POLY=PlaidPolytopeMoves.shift(a1,a2,a3,POLY0);
	              POLY=PlaidPolytopeMoves.map(dyn,POLY);
	              PolygonWrapper SLICE=POLY.slice(s,t,P);
	              if(SLICE!=null) { 
	                 Path2D.Double gp=SLICE.toPath2D();
	                 int t1=POLY.type[1];
	                 int t2=POLY.type[2];
	                 Color C=PlaidPETColors.getColor(t1,t2);
	                 fillPoly(g,gp,C);
			 polyInfo(gp,a1,a2,a3,i);
		      }
		   }}}
	}
    }


    /**Draws the 95 pieces of the clean partition*/

    public void cleanPartition(Graphics2D g) {
	int s=M.QS.DIRECTION.mode;  
        double t=M.QS.getSlice();
	double P=M.QS.getParameter();
	for(int i=0;i<190;++i) {
	    Polytope POLY=AllPolytopes.inCleanPartition(i);
            PolygonWrapper SLICE=POLY.slice(s,t,P);
	    if(SLICE!=null) {
	       Path2D.Double gp=SLICE.toPath2D();
	       int t1=POLY.type[1]; 
               int t2=POLY.type[2];
               Color C=PlaidPETColors.getColor(t1,t2);
	       fillPoly(g,gp,C);
	    }
	}
    }

    /**This draws a piece from the Orbit Equivalence Theorem.
       The options are 
  
       choice=0:  Z+
       choice=1:  Z-
       choice=2:  W+
       choice=3:  W-
    */

    public void ZPiece(int choice,Graphics2D g) {
	int s=0;
	double t=0;
	double P=1/2;

	try{
	   s=M.QS.DIRECTION.mode;   
           t=M.QS.getSlice();
	   P=M.QS.getParameter();  
	}
	catch(Exception e) {}

        Polytope POLY=AllPolytopes.ZPiece(choice);
	PolygonWrapper SLICE=POLY.slice(s,t,P);
	if(SLICE!=null) {
	   Path2D.Double gp=SLICE.toPath2D();
	   gp=transform(gp);
	   g.setStroke(new BasicStroke(4));
	   g.setColor(Color.white);
	   g.draw(gp);
	   g.setStroke(new BasicStroke(1));
	}
    }




    public void ZTiling(Graphics2D g,int choice) {
	int s=0;
	double t=0;
	double P=1/2;

	try{
	   s=M.QS.DIRECTION.mode;   
           t=M.QS.getSlice();
	   P=M.QS.getParameter();  
	}
	catch(Exception e) {}
	for(int a1=-3;a1<3;++a1) {
	    for(int a2=-3;a2<=3;++a2) {
	    for(int a3=-3;a3<=3;++a3) {
		Polytope POLY=new Polytope();
		if(choice==0) POLY=AllPolytopes.ZPlus();
		if(choice==1) POLY=AllPolytopes.ZPiece(2);
   	          POLY=PlaidPolytopeMoves.shift(a1,a2,a3,POLY);
	          PolygonWrapper SLICE=POLY.slice(s,t,P);
	          if(SLICE!=null) {
	            Path2D.Double gp=SLICE.toPath2D();
	            gp=transform(gp);
	            g.setStroke(new BasicStroke(2));
	            g.setColor(Color.white);
	            g.draw(gp);
	            g.setStroke(new BasicStroke(1));
		  }}}}
    }


    /**This draws the hitset from the monograph*/

    public void hitset(int choice,Graphics2D g) {
	int s=M.QS.DIRECTION.mode;
	double P=M.QS.getParameter();
	if(s!=2) return;
	int lim=0;

	try{
	    lim=M.QS.TILE.val; 
	}
	catch(Exception e) {}

	for(int i=-lim;i<=lim;++i) {
	for(int j=-lim;j<=lim;++j) {
	   PolygonWrapper X=new PolygonWrapper();
	   if(choice==0) X=Hitset.hitset(P,i,j);
	   if(choice==1) X=Hitset.hitsetHi(P,i,j);
	   if(choice==2) X=Hitset.hitsetLo(P,i,j);
	   Color C=new Color(150,150,150,100);
	   if(choice==1) C=new Color(100,0,100,100);
	   if(choice==2) C=new Color(0,0,200,100);
	   Path2D.Double gp=X.toPath2D();
	   fillPoly(g,gp,C);
	}}
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  {
            SOURCE=unTransform(JX);
	    PlaidGraphCommunication.sendPoint(this.M,SOURCE);
	}
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);  
	JX=J.X;
     }

   

    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.mode==2)  {
            SOURCE=unTransform(J.X);
	    PlaidGraphCommunication.sendPoint(this.M,SOURCE);
	}
	M.repaint();
    }

    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

