import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;

/**This controls the colors of the partition*/


public class PlaidPETColors { 
    ListenSquare INFO;
    Lever TRANS;
	public static Color[][] COLOR={
                       {new Color(40,60,80),
                        new Color(255,0,0),
                        new Color(255,150,0),
                        new Color(255,0,255)},
		       {new Color(200,0,0),
                        new Color(40,60,80),
                        new Color(0,220,0),
                        new Color(50,100,255)},
		       {new Color(255,220,0),
                        new Color(0,150,0),
                        new Color(40,60,80),
                        new Color(0,220,220)},
		       {new Color(200,0,200),
                        new Color(0,0,200),
                        new Color(0,160,160),
                        new Color(40,60,80)}};

    int X,Y;
    ListenSquare[][] TYPE=new ListenSquare[4][4];
    ListenSquare[] EDGE=new ListenSquare[5];  
    int edge;
  
    public PlaidPETColors() {}

    public PlaidPETColors(int x,int y) {
	X=x;
	Y=y;
	setTypes();
	initColors4();
	edge=4;
	INFO=new ListenSquare(0,0,12,12);
	TRANS=new Lever(x+65,Y-90,7,8);

    }


    public void setColors(Point X,Color C) {
	for(int i=0;i<4;++i) {
	   for(int j=0;j<4;++j) {
	       if(TYPE[i][j].inside(X)==1) {
                   COLOR[i][j]=C;
		   if(i==j) {
		       for(int k=0;k<4;++k) {
			   COLOR[k][k]=COLOR[i][j];
		       }
		   }
	       }
	   }
	}
	for(int i=0;i<5;++i) {
	    if(EDGE[i].inside(X)==1) {
                 initColors(i);
		 edge=i;
	    }
	}
    }

    public void setTypes() {
      for(int i=0;i<4;++i) {
	for(int j=0;j<4;++j) {
	    TYPE[i][j]=new ListenSquare(X+80+22*i,Y-22*j,20,20);
	}
      }
	EDGE[0]=new ListenSquare(X+95,-120+Y,50,20);
	EDGE[1]=new ListenSquare(X+75,-120+Y-50,20,50);
	EDGE[2]=new ListenSquare(X+95,-120+Y-70,50,20);
	EDGE[3]=new ListenSquare(X+145,-120+Y-50,20,50);
	EDGE[4]=new ListenSquare(X+95,-120+Y-50,50,50);
    }

    public void render(Graphics2D g) {
	drawTypes(g);
	INFO.infoRender(g);
	TRANS.render(g,"",Color.blue);
    }


    public void drawTypes(Graphics2D g) {

	for(int i=0;i<5;++i) {
	    Color CC=new Color(0,0,200);
	    if(edge==i) CC=new Color(255,180,0);
            EDGE[i].render(g,CC);
	}

	for(int i=0;i<4;++i) {
	  for(int j=0;j<4;++j) {
	    TYPE[i][j].render(g,COLOR[i][j]);
	  }
	}

        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("S",(int)(EDGE[0].x+21),(int)(EDGE[0].y+15));
	g.drawString("N",(int)(EDGE[2].x+21),(int)(EDGE[2].y+15));
	g.drawString("W",(int)(EDGE[1].x+5),(int)(EDGE[1].y+29));
	g.drawString("E",(int)(EDGE[3].x+5),(int)(EDGE[3].y+29));

	String[] S={"S","W","N","E"};
	for(int i=0;i<4;++i) {
	    g.drawString(S[i],(int)(TYPE[0][i].x-14),
              (int)(TYPE[0][i].y+13));
	    g.drawString(S[i],(int)(TYPE[i][0].x+6),
              (int)(TYPE[i][0].y+33));
	}

    }



    public void initColors(int k) {
	if(k<4) initColors0(k);
	else initColors4();
    }

    public void initColors0(int q) {
	Color C0=Color.black;
	Color C1=new Color(0,0,150);
	Color C2=new Color(255,0,255);
	Color C3=new Color(255,160,0);
	for(int i=0;i<4;++i) {
	for(int j=0;j<4;++j) {
	    COLOR[i][j]=C1;
	    if(i==q)  COLOR[i][j]=C2;
	    if(j==q)  COLOR[i][j]=C3;
	    if(i==j)  COLOR[i][j]=C0;

	}}
    }

    public void initColors4() {
	Color[][] COL={{new Color(40,60,80),
                        new Color(255,0,0),
                        new Color(255,150,0),
                        new Color(255,0,255)},
		       {new Color(200,0,0),
                        new Color(40,60,80),
                        new Color(0,220,0),
                        new Color(50,100,255)},
		       {new Color(255,220,0),
                        new Color(0,150,0),
                        new Color(40,60,80),
                        new Color(0,220,220)},
		       {new Color(200,0,200),
                        new Color(0,0,200),
                        new Color(0,160,160),
                        new Color(40,60,80)}};
	int count=1;
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		COLOR[i][j]=COL[i][j];
		++count;
	    }
	}
    }


    public void forceTransparency(Point X) {
	int test=TRANS.process(X);
	if(test==-1) return;
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
	      Color C=COLOR[i][j];
	      int r=C.getRed();
	      int g=C.getGreen();
	      int b=C.getBlue();
	      int a=32*TRANS.val;
	      COLOR[i][j]=new Color(r,g,b,a);
	    }
	}
    }



    public void process(MouseEvent e,Manager m) {
        MouseData J=MouseData.process(e);  
        setColors(J.X,m.color());
	forceTransparency(J.X);
	if(INFO.inside(J.X)==1) DocumentColors.graph(m.D);
    }


    public static Color getColor(int t1,int t2) {
	return COLOR[t1][t2];
    }




}




