import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class PlaidPETSlicer extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    int X,Y;
    double[] S=new double[4];
    double PAR;
    ControlPanel DIRECTION,LOCK,DYNAMICS;
    Path2D.Double[] SLICE=new Path2D.Double[3];
    ListenSquare CONTROL;
    ListenSquare GETPAR;  
    ListenSquare OFF;
    Lever TILE;
    Point JX;

    public PlaidPETSlicer() {
	addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	CONTROL=new ListenSquare(0,0,400,70);
	GETPAR=new ListenSquare(310,6,20,20);
	setScales(200,180,100);
	setPanels();
	PAR=4.0/11;
	double t=0;
	S[0]=t;
	S[1]=t;
	S[2]=t;
	S[3]=t;	
        TILE=new Lever(230,20,2,4);
	JX=new Point();
    }


    public void setPanels() {
         Color[] C0={new Color(80,140,255),
         Color.white,Color.white,Color.black,Color.red};
	 Color c=Color.white;

	 String[] DirectionString={"X","Y","Z","slice"};
	 int[] DirectionState={1,0,0};
         DIRECTION=new ControlPanel(C0,DirectionString,DirectionState,3);
	 DIRECTION.mode=0;

	 String[] LockString={"locked","free","parameter"};
	 int[] LockState={0,1};
         LOCK=new ControlPanel(C0,LockString,LockState,2);
	 LOCK.mode=1;

	 String[] DynamicsString={"neutral","backward","forward","PET choice"};
	 int[] DynamicsState={1,0,0};
         DYNAMICS=new ControlPanel(C0,DynamicsString,DynamicsState,3);
	 DYNAMICS.mode=0;
    }


    public Path2D.Double makeSlider(double s,double a,double w) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(-w,0);
	gp.lineTo(w,0);
	gp.lineTo(w,1);
	gp.lineTo(-w,1);
	gp.closePath();
	gp.moveTo(s,-2);
	gp.lineTo(s,3);
	gp.moveTo(-3,a);
	gp.lineTo(3,a);
	return(gp);
    }

    public Path2D.Double makeSlider2(double s,double a,double w) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=-3;i<4;++i) {
	  gp.moveTo(i-1,0);
	  gp.lineTo(i+1,0);
	  gp.lineTo(i+1,1);
	  gp.lineTo(i-1,1);
	  gp.closePath();
	  int i2=i+10;
	  if(i2%2==0) {
	    gp.moveTo(i+0,1);
	    gp.lineTo(i-1,0);
	  } 
          if(i2%2==1) {
	    gp.moveTo(i-1,1);
	    gp.lineTo(i-0,0);
	  }
	}
	return(gp);
    }

    public double getSlice() {
	int mode=DIRECTION.mode;
	return(S[mode]);
    }

    public double getParameter() {
	return PAR;
    }

    public int getDynamics() {
	return(DYNAMICS.mode);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawControls(g);     
   }

    public void drawControls(Graphics2D g) {
	drawSlider(g);
	drawPanel(g);
	TILE.render(g,"tiling extent",Color.blue);
	g.setColor(Color.white);
	g.drawString("grab (P)",338,12);
	g.drawString("parameter",338,27);




    }

    public void drawSlider(Graphics2D g) {
	g.setColor(new Color(255,140,0));
	g.fillRect(0,0,getWidth(),getHeight());
	int p=M.p();
	int q=M.q();
	double A=1.0*p/q;
	double[] w={8,1,1,1};
	int c=DIRECTION.mode;
	Path2D.Double gp=makeSlider(S[c],PAR,w[c]);
	gp=transform(gp);
	g.setColor(new Color(0,50,255));
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp); 
        gp=makeSlider2(S[c],PAR,w[c]);
	gp=transform(gp);
	g.setColor(new Color(255,255,255,70));
	g.draw(gp); 
    }


    public PolygonWrapper project(Polytope P) {
        int s=DIRECTION.mode;
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.z[i]=new Complex(P.V[i].x[s],P.V[i].x[3]);
	}
	Q=PolygonWrapper.cheapHull(Q);
	return(Q);
    }



    public void drawPanel(Graphics2D g) {
	CONTROL.render(g,new Color(0,0,100));
	DIRECTION.render(g,0,0,45);
	LOCK.render(g,50,0,75);
	DYNAMICS.render(g,130,0,95);
	GETPAR.render(g,new Color(0,0,255));

    }

    public void grabParameter() {
	int p=M.p();
	int q=M.q();
	PAR=2.0*p/(p+q);
    }


    public void documentStuff(Point X) {
	if(DIRECTION.L[20].inside(X)==1) DocumentPlaid.slice(M.D);
	if(LOCK.L[20].inside(X)==1) DocumentPlaid.lock(M.D);
	if(DYNAMICS.L[20].inside(X)==1) DocumentPlaid.partition(M.D);
	if(TILE.L[4].inside(X)==1) DocumentPlaid.tiling(M.D);
    }


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	DIRECTION.switchMode(J.X);
	DYNAMICS.switchMode(J.X);
	TILE.process(J.X);
	LOCK.switchMode(J.X);
	if(GETPAR.inside(J.X)==1) grabParameter();
	if(CONTROL.inside(J.X)==0) {
          if(J.mode==1)  scaleUp(J.X,0);
          if(J.mode==2)  {
	      int c=DIRECTION.mode;
              Complex z=unTransform(J.X);
	      S[c]=z.x;
	      if((LOCK.mode==1)&&(z.y>0)&&(z.y<1)) PAR=z.y;
	  }
          if(J.mode==3)  scaleUp(J.X,1);
	}
	documentStuff(J.X);
	M.repaint();
    }



    public void doMouseClick(int mode) {
	DIRECTION.switchMode(JX);
	DYNAMICS.switchMode(JX);
	TILE.process(JX);
	LOCK.switchMode(JX);
	if(GETPAR.inside(JX)==1) grabParameter();
	if(CONTROL.inside(JX)==0) {
          if(mode==1)  scaleUp(JX,0);
          if(mode==2)  {
	      int c=DIRECTION.mode;
              Complex z=unTransform(JX);
	      S[c]=z.x;
	      if((LOCK.mode==1)&&(z.y>0)&&(z.y<1)) PAR=z.y;
	  }
          if(mode==3)  scaleUp(JX,1);
	}
	documentStuff(JX);
	M.repaint();
    }





    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	DIRECTION.switchMode(J.X);
	if(CONTROL.inside(J.X)==0) {
          if(J.mode==2)  {
	      int c=DIRECTION.mode;
              Complex z=unTransform(J.X);
	      S[c]=z.x; 
              if((LOCK.mode==1)&&(z.y>0)&&(z.y<1)) PAR=z.y;
	  }
	}
	M.repaint();
    }

    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


    public void mousePressed(MouseEvent e) {

    }

    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
    public void mouseExited(MouseEvent e) {}   
    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=J.X;
    }


}


