import java.awt.*;
import java.math.*;
import java.awt.geom.*;

/**This file converts from the plaid classifying map
   the the arithmetic graph classifying map.*/

public class PlaidToGraph {

    /**This is the main routine*/

    public static Vector4 omega(Vector4 U) {
	Vector4 V=omegaRaw(U);
	V=AGMap.reduce(V);
	return AGMap.reduce(V);
    }

    public static Vector4 omegaRaw(Vector4 V) {
	int[] x=ZComponent(V);
	int guide=x[2];  
	Vector4 W=translateBack(x,V);
	return omega(guide,W);
    }

    /**This routine assumes that U is in one of 
       the basic pieces.  The vector we are looking
       for has the form V/d.  We can't always do this
       division over the longs, so we keep track of
       the pair (V,d) and deal with the division later.*/


    public static Vector4  omega(int guide,Vector4 U) {
	double P=U.x[3];
	Vector4 H1=new Vector4(U.x[0]-U.x[1],-U.x[1],U.x[2],P);
	Vector4 H2=new Vector4(0,0,0,0);
	if(guide==0) H2=new Vector4(-2+P,+1,-1-P,0);  
	if(guide==1) H2=new Vector4(+2-P,-1,+1+P,0);  
	if(guide==2) H2=new Vector4(-2+P,-1+2*P,+1-P,0); 
	if(guide==3) H2=new Vector4(+2-P,+1-2*P,-1+P,0);
	Vector4 H3=Vector4.plus(H1,H2);
	H3=H3.scale(1.0/(2-P));
	return H3;
    }

    /**This routine translates the polytope back to one
       of the pieces Z+, Z-, Z'+, Z'-*/

    public static Vector4 translateBack(int[] x,Vector4 V) {
	int k0=x[0];
	int k1=x[1];
        Vector4 W=PlaidPolytopeMoves.shift(-2*k0,-k1,0,V);
	return W;
    }

    /**This routine finds the component of the
       Z partition containing the polytope.*/

    public static int[] ZComponent(Vector4 V) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<4;++i) {
	    Polytope Q0=AllPolytopes.ZPiece(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
		Polytope Q=PlaidPolytopeMoves.shift(2*k0,k1,0,Q0);
		if(Q.contains(V)) {
		    int[] x={k0,k1,i};
		    return x;
		}
	    }}}}
	    return null;
	}









}



