import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    public class PolytopeInfo extends ScaleCanvas implements MouseListener,MouseMotionListener {

     Manager M;
	int[] LIST;
	int[] POLY=new int[10];
	int[] DATA=new int[3];

     public PolytopeInfo() {
	addMouseListener(this);
	addMouseMotionListener(this);
	LIST=null;
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
             
      RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);  
      if(LIST==null) return;
      for(int i=0;i<LIST.length;++i) {printInfo(g,LIST[i]);}
   }

   public void drawBG(Graphics2D g) {
       g.setColor(new Color(60,80,100));
     g.fillRect(0,0,this.getWidth(),this.getHeight());
   }


	public void printInfo(Graphics2D g,int k) {
	    System.out.println("choice "+k);
	    if(k==0) graphSingleInfo(g);
	    if(k==1) plaidSingleInfo(g);
	    if(k==2) plaidCleanInfo(g);
	}  

	public void printPoly(Graphics2D g,Polytope P,int XVAL,int YVAL) {
          for(int i=0;i<P.count;++i) {
	      for(int j=0;j<4;++j) {
		  Integer L=new Integer((int)(P.V[i].x[j]));
		  g.drawString(L.toString(),XVAL+40*j,YVAL+30*i);
	      }
	  }
	}

      public void graphSingleInfo(Graphics2D g) {
          g.setFont(new Font("Helvetica",Font.PLAIN,18));
	  g.setColor(Color.yellow);
	  g.drawString("graph single",10,20);
	  g.drawString("shifted polytope",205,20);
	  Integer a=new Integer(POLY[0]);
	  g.drawString(a.toString(),10,50);
	  if(DATA[3]==0)  g.drawString("+ partition",45,50);
	  if(DATA[3]==1)  g.drawString("- partition",45,50);
	  a=new Integer(DATA[4]);
	  g.drawString("label   "+a.toString(),10,80);	
          a=new Integer(DATA[5]);
	  g.drawString(a.toString(),85,80);

	  for(int i=0;i<3;++i) {
	      a=new Integer(DATA[i]);
	      g.drawString(a.toString(),205+40*i,50);
	  }

	  g.setColor(Color.white);
	  Polytope P=AllPolytopes.graph(POLY[0]);
	  printPoly(g,P,10,140);
	  P=GraphPolytopeMoves.shift(DATA[0],DATA[1],DATA[2],P);
          printPoly(g,P,205,140);


	  double A=1.0*M.p()/M.q();
	  Complex z=AGTransforms.k2pLinear(A,new Complex(DATA[4],DATA[5]));
	  Path2D.Double gp=new Path2D.Double();
	  gp.moveTo(140,75);
	  gp.lineTo(140+30*z.x,75-30*z.y);
	  g.setStroke(new BasicStroke(3));
	  g.draw(gp);
	  g.setStroke(new BasicStroke(12));
	  gp.reset();
	  gp.moveTo(140,75);
	  gp.lineTo(140,75);
	  g.draw(gp);
	  g.setStroke(new BasicStroke(1));
      }


      public void plaidSingleInfo(Graphics2D g) {
	  String[] LABEL={"S","W","N","E"};
          g.setFont(new Font("Helvetica",Font.PLAIN,18));
	  g.setColor(Color.yellow);
	  g.drawString("plaid single",10,20);
	  g.drawString("shifted polytope",205,20);
	  Integer a=new Integer(POLY[1]);
	  g.drawString(a.toString(),10,50);
	  if(DATA[3]!=DATA[4]) {
	    a=new Integer(DATA[3]);
	    g.drawString("label   "+LABEL[DATA[3]],10,80);	
            a=new Integer(DATA[4]);
	    g.drawString(LABEL[DATA[4]],80,80);
	  }
	  else {
            g.drawString("label (null)",10,80);
	  }
 
	  for(int i=0;i<3;++i) {
	      a=new Integer(DATA[i]);
	      g.drawString(a.toString(),205+40*i,50);
	  }

	  g.setColor(Color.white);
	  Polytope P=AllPolytopes.plaid(POLY[1]);
	  printPoly(g,P,10,140);
	  P=PlaidPolytopeMoves.shift(DATA[0],DATA[1],DATA[2],P);
          printPoly(g,P,205,140);
      }



	public void plaidCleanInfo(Graphics2D g) {}

    public void mouseClicked(MouseEvent e) {}

	public void mouseDragged(MouseEvent e) {}

    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}   
    public void mouseMoved(MouseEvent e) {}


    }
