import java.awt.*;
import java.math.*;


public class ReconstructionFormula {

    /**This goes from the graph PET to the plane.*/

    public static Complex graphVersion(Vector4 V) {
	double A=V.x[3];
	double x=V.x[0];
	double y=(V.x[1]-A*V.x[0])/(1+A);
	double f=Math.floor(x);
	x=x-f;
	y=y+f;
	return(new Complex(x,y));
    }



    /**This goes from the plaid PET to the plane.*/

    public static Complex plaidVersion1(double[] d,double A) {
	double P=2*A/(1+A);
	double x0=d[0];
	double x1=d[1];
	double m=1;
	if(x0>x1) m=-1;
	double u=(x0-x1)/(2-P);
	if(u>1) throw new ProofException("ugh");
	double v=(-P*(u+m)-x1+1)/2;
	return(new Complex(u,v));
    }

    /**This just works in the dipole fundamental domain.*/

    public static Complex plaidVersion2(double[] d,double A) {
	double P=2*A/(1+A);
	double x=d[0];
	double y=d[1];
	double u=(x-y)/(2-P);
	double v=(-2-P+P*P+P*x+2*y-2*P*y)/(2*P-4);
	return(new Complex(u,v));
    }



}




