import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


 public class SanityCheck1 {

     /**This takes a complete list of points in the plaid grid,
        modulo symmetry, applies the classifying map, and
        plots the result in the plaid PET canvas.  This is
        supposed to match the partition.  It is a check that
        our Plaid Master Picture Theorem is correct.*/

     public static void drawClassMap(Graphics2D g,Manager M) {
	Path2D.Double gp=new Path2D.Double();
	int p=M.C.PAR.getNumerator();
	int q=M.C.PAR.getDenominator();
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	int k=p+q;
	Tile T=new Tile();

	double min=M.QS.getSlice()-1.0/(p+q);
	double max=min+2.0/(p+q);
	int lim=-k;
	double[] U={0,0,0,0};
        for(int i=0;i<2*k*k;++i) {
	    for(int j=lim;j<k;++j) {
		Vector4 V=PlaidClassifyingMap.PHI(A,i+.5,j+.5);
	        if((V.x[0]>min)&&(V.x[0]<max)) { 
                  T=new Tile(p,q,i,j);
		  int[] I=PlaidClassify.classify(T);
		  gp=makeSquare(p,q,V.x[1],V.x[2]);
		  g.setColor(PlaidPETColors.COLOR[I[0]][I[1]]);
		  gp=M.Q.transform(gp);
		  g.fill(gp);
	    }
	  }
	}
    }

    public static Path2D.Double makeSquare(int p,int q,double x0,double x1) {
	Path2D.Double gp=new Path2D.Double();
	double y=1.0/(p+q);
	gp.moveTo(x0-y,x1-y);
	gp.lineTo(x0+y,x1-y);
	gp.lineTo(x0+y,x1+y);
	gp.lineTo(x0-y,x1+y);
	gp.closePath();
	return(gp);
    }

 }