import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


 public class SanityCheck2 {

     /**This plots the images of all the grid full squares
        under the plaid classifying map PSI and checks
        they they land in the hitset.  This is supposed to
        be done when you are using the Z slice.*/


     public static void plotHitset(Graphics2D g,Manager M) {
	int p=M.p();
	int q=M.q();
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	int w=p+q;
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<2*w*w;++i) {
	    for(int j=0;j<2*w;++j) {	 
              if(AGLattice.goodPoint(p,q,i+.5,j+.5)==true) {
                Complex u=AGLattice.nearestGrid(p,q,i+.5,j+.5); 
		u=AGTransforms.p2kAffine(p,q,u);
		int m=(int)(Math.floor(u.x+.5));
		int n=(int)(Math.floor(u.y+.5));
		Vector4 d1=AGMap.PSI(p,q,m,n);
		Vector4 V=PlaidClassifyingMap.PHI(A,i+.5,j+.5); 
	        Vector4 d2=PlaidToGraph.omega(V);
		double d=Vector4.dist2(d1,d2);
		boolean test=true;
		if(d>.0000001) test=false;
	        double min=M.QS.getSlice()-1.0/(p+q);
	        double max=min+2.0/(p+q);
		if((V.x[2]>min)&&(V.x[2]<max)) {
                  gp=makeSquare(p,q,V.x[0],V.x[1]);
		  gp=M.Q.transform(gp);
		  g.setColor(Color.red);
		  if(test==true) g.setColor(Color.blue);
		     g.fill(gp);
		}
	      }
	    }
	}
    }

    public static Path2D.Double makeSquare(int p,int q,double x0,double x1) {
	Path2D.Double gp=new Path2D.Double();
	double y=1.0/(p+q);
	gp.moveTo(x0-y,x1-y);
	gp.lineTo(x0+y,x1-y);
	gp.lineTo(x0+y,x1+y);
	gp.lineTo(x0-y,x1+y);
	gp.closePath();
	return(gp);
    }

 }