import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Spacetime extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Color[] COLOR=new Color[7];
    Output OUT;
    Complex Z;
    Point JX;


     public Spacetime() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(10,390,34.5);
	 Z=new Complex();	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(M.C.SPACETIME.L[7].on==1) drawLowCapacity(g);
      int a=horizontalOrVertical(Z);
      if(a==0) {
          if(M.C.SPACETIME.L[2].on==1) drawHorizontal1(g);
          if(M.C.SPACETIME.L[2].on==1) drawHorizontal2(g);
          if(M.C.SPACETIME.L[3].on==1) drawPixellation(g,0);
      }
      if(a==1) {
          if(M.C.SPACETIME.L[2].on==1) drawVertical1(g);
          if(M.C.SPACETIME.L[2].on==1) drawVertical2(g);
          if(M.C.SPACETIME.L[4].on==1) drawPixellation(g,1);
      } 
      if(M.C.SPACETIME.L[5].on==1) drawFrame(g);
      if(M.C.SPACETIME.L[6].on==1) drawMarker(g);
   }


    public static int whichBlock(int p,int q,int x) {
	int k=whichBlockRaw(p,q,x);
	int w=p+q;
	int t=(-2*k*p+2*w*w*w)%w;
	return t;
    }

    public static int whichBlockRaw(int p,int q,int x) {
	int w=p+q;
	int k=x/w;
	return k;
    }




    public static int horizontalOrVertical(Complex z) {
	double x=Math.abs(z.x-Math.floor(z.x+.5));
	double y=Math.abs(z.y-Math.floor(z.y+.5));
	if(y<x) return 0;
	return 1;
    }


    public int capacity() {
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int h=horizontalOrVertical(Z);
	int n=0;
	if(h==0) n=(int)(Math.floor(Z.y+.5));
	if(h==1) n=(int)(Math.floor(Z.x+.5));
	return PlaidFunctions.capacity(p,q,n);
    }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.SPACETIME.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight()); 
	int p=M.p();
	int q=M.q();
	int w=p+q;
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<=w;++i) {
	    gp.moveTo(0,i);
	    gp.lineTo(w,i);
	    gp.moveTo(0,i+w);
	    gp.lineTo(w,i+w);
	    gp.moveTo(i,0);
	    gp.lineTo(i,2*w);
	}
	gp=transform(gp);
	g.setColor(M.C.SPACETIME.M[1].C);
	if(M.C.SPACETIME.L[1].on==1) g.draw(gp);
    }



    public void drawLowCapacity(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int k0=M.C.CAPACITY2.val;

	Path2D.Double gp=new Path2D.Double();

	for(int i=0;i<=w;++i) {
	    int k=PlaidFunctions.capacity(p,q,i);
	    if(k<=k0) {
	       gp.moveTo(i,0);
	       gp.lineTo(i,2*w);
	    }
	}
	gp=transform(gp);
	g.setColor(M.C.SPACETIME.M[7].C);
	if(M.C.SPACETIME.L[7].on==1) g.draw(gp);
    }




    public void drawFrame(Graphics2D g) {
	Path2D.Double gp=getFrame();
	gp=transform(gp);
	g.setColor(M.C.SPACETIME.M[5].C);
	if(M.C.SPACETIME.M[5].on==1) g.draw(gp);
    }


    public Path2D.Double getFrame() {
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int y=M.C.FRAME.val;
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(0,y);
	gp.lineTo(w,y);
	gp.lineTo(w,w+y);
	gp.lineTo(0,w+y);	
	gp.closePath();
	return gp;

    }

    public void drawMarker(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int a=horizontalOrVertical(Z);	
        int n1=(int)(Math.floor(Z.y));
	int n2=(int)(Math.floor(Z.x));
	int i=0;
	int j=0;
	int k1=whichBlockRaw(p,q,n2);
	int nn2=n2-k1*w;
	int k2=whichBlock(p,q,n2);
	if(a==0) {
	    i=nn2;
	    j=k2;
	}
	if(a==1) {
	    i=n1;
	    j=k2;
	}
	Path2D.Double gp=new Path2D.Double();
	for(int ii=-2;ii<2;++ii) {
	   gp.reset();
	   gp.moveTo(i+ii*w,j);
	   gp.lineTo(i+1+ii*w,j);
	   gp.lineTo(i+1+ii*w,j+1);
	   gp.lineTo(i+ii*w,j+1);
	   gp.closePath();
	   gp=transform(gp);
	   g.setColor(M.C.SPACETIME.M[6].C);
	   if(M.C.SPACETIME.M[6].on==1) g.draw(gp);
	}
    }





    public void drawHorizontal1(Graphics2D g) {
	Tile T=new Tile();
	int n=(int)(Math.floor(Z.y+.5));
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int t=MathRational.tune(p,q,p+q-1);
	for(int i=0;i<w;++i) {
	    for(int j=0;j<=2*w;++j) {
		int k=i+(j*t*w)%(w*w);
		T=new Tile(p,q,k,n);
                Complex[] W=PlaidModel.getPoints(T);
   	        int[][] on=PlaidModel.getCountRaw(T,W);
		if((on[0][1]==1)&&(on[0][0]==1)) 
		    drawPoint(g,i+.5,j,Color.white);

	    }
	}
	g.setStroke(new BasicStroke(1));
    }


    public void drawVertical1(Graphics2D g) {
	Tile T=new Tile();
	int p=M.p();
	int q=M.q();
	int w=p+q;
	int n0=(int)(Math.floor(Z.x+.5));
	int kk=whichBlockRaw(p,q,n0);
	int n=n0-kk*(p+q);
	int t=MathRational.tune(p,q,p+q-1);
	for(int i=0;i<w;++i) {
	    for(int j=0;j<=2*w;++j) {
		int k=n+(j*t*w)%(w*w);
		T=new Tile(p,q,k,i);
                Complex[] W=PlaidModel.getPoints(T);
   	        int[][] on=PlaidModel.getCountRaw(T,W);
		if((on[1][1]==1)&&(on[1][0]==1)) {
		    drawPoint(g,i+.5,j,Color.white);
		}

	    }
	}
	g.setStroke(new BasicStroke(1));
    }


    public void drawHorizontal2(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	int p=M.p();
	int q=M.q();
	int n=(int)(Math.floor(Z.y+.5));
	Complex[][] LINES=getLinesH(p,q,n);
	for(int i=0;i<LINES.length;++i) {
	    gp.reset();
	    gp.moveTo(LINES[i][0].x,LINES[i][0].y);
	    gp.lineTo(LINES[i][1].x,LINES[i][1].y);
	    gp=transform(gp);
	    g.setColor(M.C.SPACETIME.M[2].C);  
	    if(LINES[i][0].dir==1) g.setColor(Color.yellow);
	    g.draw(gp);
	}
    }



    public void drawVertical2(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	int p=M.p();
	int q=M.q();
	int n=(int)(Math.floor(Z.x+.5));
	Complex[][] LINES=getLinesV(p,q,n);
	for(int i=0;i<LINES.length;++i) {
	    gp.reset();
	    gp.moveTo(LINES[i][0].x,LINES[i][0].y);
	    gp.lineTo(LINES[i][1].x,LINES[i][1].y);
	    gp=transform(gp);
	    g.setColor(M.C.SPACETIME.M[2].C); 
	    if(LINES[i][0].dir==1) g.setColor(Color.yellow);
	    g.draw(gp);
	}
    }

    /**This routine draws the pixellated tiles*/

    public void drawPixellation(Graphics2D g,int choice) {
	g.setStroke(new BasicStroke(2));
	Path2D.Double gp=new Path2D.Double();
	Path2D.Double gp1=new Path2D.Double();
	Path2D.Double gp2=new Path2D.Double();
	Complex[][] LINES=new Complex[0][0];
	int p=M.p();
	int q=M.q();
	int n1=(int)(Math.floor(Z.y+.5));
	int n2=(int)(Math.floor(Z.x+.5));
	if(choice==0) LINES=getLinesH(p,q,n1);
	if(choice==1) LINES=getLinesV(p,q,n2);
	int w=p+q;
	AffineTransform AFF1=AffineTransform.getTranslateInstance(0,w);
	AffineTransform AFF2=AffineTransform.getTranslateInstance(0,-w);
	for(int i=0;i<w;++i) {
	    for(int j=0;j<2*w;++j) {
		if(choice==0) gp=tileHPath(p,q,LINES,i,j);
		if(choice==1) gp=tileVPath(p,q,LINES,i,j);
		g.setColor(M.C.SPACETIME.M[3+choice].C);
		gp=transform(gp);
		g.draw(gp);
	    }
	}
	g.setStroke(new BasicStroke(1));
    }


    public static Path2D.Double tileHPath(int p,int q,Complex[][] LINES,int i,int j) {
           Path2D.Double gp=new Path2D.Double();
	   Complex[] z=tileHRaw(p,q,LINES,i,j);
	   if(z==null) return gp;
	   gp.moveTo(z[0].x,z[0].y);
	   gp.lineTo(z[1].x,z[1].y);
	   return gp;
    }

    public static Path2D.Double tileVPath(int p,int q,Complex[][] LINES,int i,int j) {
           Path2D.Double gp=new Path2D.Double();
	   Complex[] z=tileVRaw(p,q,LINES,i,j);
	   if(z==null) return gp;
	   for(int ii=0;ii<z.length/2;++ii) {
	      gp.moveTo(z[2*ii+0].x,z[2*ii+0].y);
	      gp.lineTo(z[2*ii+1].x,z[2*ii+1].y);
	   }
	   return gp;
    }

    public static Complex[][] sides(int i,int j) {
	Complex[] e0={new Complex(i+1,j+0),new Complex(i+0,j+0)};
	Complex[] e1={new Complex(i+0,j+0),new Complex(i+0,j+1)};
	Complex[] e2={new Complex(i+0,j+1),new Complex(i+1,j+1)};
	Complex[] e3={new Complex(i+1,j+1),new Complex(i+1,j+0)};
	Complex[][] e={e0,e1,e2,e3};
	return e;
    }

    public static Complex[] sideCenters(int i,int j) {
	Complex[][] e=sides(i,j);
	Complex[] ee=new Complex[4];
	for(int k=0;k<4;++k) {
	    ee[k]=Complex.plus(e[k][0],e[k][1]);
	    ee[k]=Complex.times(ee[k],new Complex(.5,0));
	}
	return ee;
    }


    public static Complex[] tileHRaw(int p,int q,Complex[][] LINES,int i,int j) {
	Complex[] ee=sideCenters(i,j);
	int[] n=tileHNums(p,q,LINES,i,j);
	for(int k1=0;k1<4;++k1) {
	    for(int k2=k1+1;k2<4;++k2) {
		 if((n[k1]==1)&&(n[k2]==1)) {
		     Complex[] z={ee[k1],ee[k2]};
		     return z;
		}
	    }
	}
	return null;
    }





    public static int[] tileHNums(int p,int q,Complex[][] LINES,int i,int j) {
	Complex[][] e=sides(i,j);
	Complex[] ee=sideCenters(i,j);
	int[] n=new int[4];
	for(int k=0;k<4;++k) n[k]=crossingNumber(LINES,e[k]);


	if(i==0) { 
            n[1]=0;
	    if(j!=0) {
	      if(n[0]>1) --n[0];
	    }
	    if(n[2]>1) --n[2];
	}

	if(i==p+q-1) { 
            n[3]=0;
	    //if(j!=p+q-1) {
	      if(n[2]>1) --n[2];
	      //}
	    if(j!=0) {
	       if(n[0]>1) --n[0];
	    }
	}
	for(int ii=0;ii<4;++ii) n[ii]=n[ii]%2;
	return n;
    }

    public static Complex[] tileVRaw(int p,int q,Complex[][] LINES,int i,int j) {
	Complex[][] e=sides(i,j);
	Complex[] ee=sideCenters(i,j);

	int[] n=tileVNums(p,q,LINES,i,j);
	int sum=n[0]+n[1]+n[2]+n[3];
	if(sum==0) return null;

	if(sum==2) {
	   for(int k1=0;k1<4;++k1) {
	      for(int k2=k1+1;k2<4;++k2) {
		 if((n[k1]==1)&&(n[k2]==1)) {
		     Complex[] z={ee[k1],ee[k2]};
		     return z;
		}
	      }
	   }
	}

	int test=n[0];

	if(test==1) {
	    Complex[] z={ee[0],ee[1],ee[2],ee[3]};
	    return z;
	}
	if(test==3) {
	    Complex[] z={ee[0],ee[3],ee[1],ee[2]};
	    return z;
	}

	return null;
    }



    public static int[] tileVNums(int p,int q,Complex[][] LINES,int i,int j) {
	Complex[][] e=sides(i,j);
	Complex[] ee=sideCenters(i,j);

	int[] n=new int[4];
	for(int k=0;k<4;++k) {
	    n[k]=crossingNumber(LINES,e[k]);
	    n[k]=n[k]%2;
	}

	int sum=n[0]+n[1]+n[2]+n[3];
	if(sum<4) return n;

	int test=specialType(LINES,e[0]);
	if(test==2) n[0]=3;
	return n;
    }



    public static int specialType(Complex[][] LINES,Complex[] EDGE) {
	int count=0;
	for(int i=0;i<LINES.length;++i) {
	    boolean test=crosses(LINES[i],EDGE);
	    if(test==true) return(LINES[i][0].type);
	}
	return count;
    }



    public static int crossingNumber(Complex[][] LINES,Complex[] EDGE) {
	int count=0;
	for(int i=0;i<LINES.length;++i) {
	    boolean test=crosses(LINES[i],EDGE);
	    if(test==true) {
		++count;
	    }
	}
	return count;
    }

    public static boolean crosses(Complex[] LINE,Complex[] EDGE) {
	Complex z=Complex.findCross(LINE[0],LINE[1],EDGE[0],EDGE[1]);
	boolean test=Complex.onSegment(z,EDGE[0],EDGE[1]);
	return test;
    }


    /**Gets all the segments in the horizontal spacetime slice*/

    public static Complex[][] getLinesH(int p,int q,int n0) {
	int kk=whichBlockRaw(p,q,n0);
	int n=n0-kk*(p+q);
	Complex[] POINTS=getPointsH(p,q,n);
	int w=p+q;
	Complex[][] LIST=new Complex[POINTS.length][2];
	Complex b0=new Complex(0,0);
	Complex b1=new Complex(w,2*w);
	for(int i=0;i<POINTS.length;++i) {
	    Complex z0=new Complex(POINTS[i]);
	    Complex z1=new Complex(z0);
	    if(z0.type==1) {
		z1=Complex.plus(z0,new Complex(w,2*p));
	    }
	    if(z0.type==2) {
		z1=Complex.plus(z0,new Complex(w,-2*q));
	    }
	    LIST[i][0]=new Complex(z0);
	    LIST[i][1]=new Complex(z1);
	    LIST[i]=GraphicsHelp.trim(b0,b1,LIST[i]);
	    try{
              LIST[i][0].type=POINTS[i].type;
	      LIST[i][1].type=POINTS[i].type;
              LIST[i][0].dir=POINTS[i].dir;
	      LIST[i][1].dir=POINTS[i].dir;
	    }
	    catch(Exception e) {}
	}
	LIST=GraphicsHelp.weedOut(LIST);
	return LIST;
    }

    /**Gets all the segments in the horizontal spacetime slice*/

    public static Complex[][] getLinesV(int p,int q,int n0) {
	int kk=whichBlockRaw(p,q,n0);
	int n=n0-kk*(p+q);
	Complex[] POINTS=getPointsV(p,q,n);
	int w=p+q;
	Complex[][] LIST=new Complex[POINTS.length][2];
	Complex b0=new Complex(0,0);
	Complex b1=new Complex(w,2*w);
	for(int i=0;i<POINTS.length;++i) {
	    Complex z0=new Complex(POINTS[i]);
	    Complex z1=new Complex(z0);
	    if(z0.type==1) {
		z1=Complex.plus(z0,new Complex(w,w));
	    }
	    if(z0.type==2) {
		z1=Complex.plus(z0,new Complex(w,-w));
	    }
	    LIST[i][0]=new Complex(z0);
	    LIST[i][1]=new Complex(z1);
	    LIST[i]=GraphicsHelp.trim(b0,b1,LIST[i]);
	    try{ 
                LIST[i][0].type=POINTS[i].type;
	        LIST[i][1].type=POINTS[i].type;
                LIST[i][0].dir=POINTS[i].dir;
	        LIST[i][1].dir=POINTS[i].dir;
	    }
	    catch(Exception e) {}
	}
	LIST=GraphicsHelp.weedOut(LIST);
	return LIST;
    }





    /**Gets all the light points in the horizontal spacetime slice*/

    public static Complex[] getPointsH(int p,int q,int n0) {
	int kk=whichBlockRaw(p,q,n0);
	int n=n0-kk*(p+q);
	Tile T=new Tile();
	int w=p+q;
	Complex[] LIST=new Complex[4*w*w];
	int count=0;
	int t=MathRational.tune(p,q,p+q-1);
	for(int i=0;i<w;++i) {
	    for(int j=0;j<=2*w;++j) {
		int k=i+(j*t*w)%(w*w);
		T=new Tile(p,q,k,n);
                Complex[] W=PlaidModel.getPoints(T);
	        for(int l=0;l<8;++l) {
	            if(W[l].wall==0) {
		        if(PlaidModel.isLight(p,q,W[l])==1) {
        		   LIST[count]=new Complex(W[l]);
			   LIST[count].x=LIST[count].x-k+i;
			   LIST[count].y=j; 
                           if(j%2==1) LIST[count].dir=-LIST[count].dir;
		           ++count;
			}
		    }
		}
	    }
	}
	Complex[] LIST2=new Complex[count];
	for(int i=0;i<count;++i) LIST2[i]=new Complex(LIST[i]);
	return LIST2;
    }


    /**Gets all the light points in the vertical spacetime slice*/

    public static Complex[] getPointsV(int p,int q,int n0) {
	int kk=whichBlockRaw(p,q,n0);
	int n=n0-kk*(p+q);
	Tile T=new Tile();
	int w=p+q;
	Complex[] LIST=new Complex[4*w*w];
	int count=0;
	int t=MathRational.tune(p,q,p+q-1);
	for(int i=0;i<w;++i) {
	    for(int j=0;j<=2*w;++j) {
		int k=n+(j*t*w)%(w*w);	
		T=new Tile(p,q,k,i);
                Complex[] W=PlaidModel.getPoints(T);
	        for(int l=0;l<8;++l) {
	            if(W[l].wall==1) {
		        if(PlaidModel.isLight(p,q,W[l])==1) {
		           LIST[count]=new Complex(W[l]);
			   LIST[count].x=LIST[count].y;
			   LIST[count].y=j;
			   if(j%2==1) LIST[count].dir=-LIST[count].dir;
		           ++count;
			}
		    }
		}
	    }
	}
	Complex[] LIST2=new Complex[count];
	for(int i=0;i<count;++i) LIST2[i]=new Complex(LIST[i]);
	return LIST2;
    }







    public void drawPoint(Graphics2D g,double i,double j,Color C) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(i,j);
	gp.lineTo(i,j);
	gp=transform(gp);
	g.setStroke(new BasicStroke(5));
	g.setColor(C);
	g.fill(gp);
	g.draw(gp);
    }




    public void rescale() {
	Path2D.Double gp=getFrame();
	int w=getWidth();
	int h=getHeight();
        A=GraphicsHelp.preFit(gp,2,10,w-4,h-20);
    }



    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  {
             SOURCE=unTransform(JX);
	}
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
         MouseData J=MouseData.process(e);
	 JX=J.X;
     }
  
     public void mouseDragged(MouseEvent e) {
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(ch=='r') rescale();
	if(ch=='a') {
             ++M.C.FRAME.val;
	     rescale();
	}

	if(ch=='s') {
             --M.C.FRAME.val;
	     rescale();
	}

	if(test>0) doMouseClick(test);
	M.repaint();
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

