import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Truchet extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Output OUT;
    Point JX;
    ListenSquare TOP;

     public Truchet() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(5,440,380);
	 TOP=new ListenSquare(0,0,1000,50);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawRational(g);
      drawMain(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(180,0,80));
        g.fillRect(0,0,getWidth(),getHeight()); 
	TOP.render(g,Color.black);
    }

    public void drawRational(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int[] m=MathRational.getTruchet(p,q);
	Integer P=new Integer(m[0]);
	Integer Q=new Integer(m[1]);
        g.setFont(new Font("Helvetica",Font.PLAIN,45));
	g.drawString(P.toString()+"/"+Q.toString(),5,40);
    }


    public void drawMain(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int[] m=MathRational.getTruchet(p,q);
	int[] s=sequence(m);
	Path2D.Double gp=new Path2D.Double();


	for(int i=1;i<s.length;++i) {
	    for(int j=1;j<s.length;++j) {
		drawTile(g,s,i,j);
	    }
	}

	for(int i=1;i<s.length;++i) {
	    drawSquare(0,g,s,i);
	    drawSquare(1,g,s,i);
	}

	drawShield(g,s.length);
    }


    public int[] sequence(int[] m) {
	double a=1.0*m[0]/m[1];
	int[] s=new int[m[1]+1];
	for(int i=1;i<=m[1];++i) {
	    double d=i*a-a/2;
	    d=d-Math.floor(d);
	    if(d<.5) s[i]=1;
	    if(d>.5) s[i]=0;
	}
	return s;
    }



    public void drawSquare(int choice,Graphics2D g,int[] s,int i) {
	Path2D.Double gp=new Path2D.Double();
	double x=1.0*i/(s.length);
	double y=0;
	double w=1.0/(s.length);
	if(choice==1) {
	    y=x;
	    x=0;
	}
	gp.moveTo(x,y);
	gp.lineTo(x+w,y);
	gp.lineTo(x+w,y+w);
	gp.lineTo(x,y+w);
	gp.closePath();
	gp=transform(gp);
	Color C1=Color.white;
	Color C2=Color.black;
	if(s[i]==1) {
	    C1=Color.black;
	    C2=Color.white;
	}
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.draw(gp);
    }


    public void drawTile(Graphics2D g,int[] s,int i,int j) {
	Path2D.Double gp=new Path2D.Double();
	Path2D.Double gp2=new Path2D.Double();
	double x=1.0*i/(s.length);
	double y=1.0*j/(s.length);
	double w=1.0/(s.length);

	gp.moveTo(x,y);
	gp.lineTo(x+w,y);
	gp.lineTo(x+w,y+w);
	gp.lineTo(x,y+w);
	gp.closePath();
	gp=transform(gp);

	int m=(s[i]+s[j])%2;
	double d=w/2;
	if(m==1) {
	    gp2.moveTo(x+0,y+d);
	    gp2.lineTo(x+d,y+w);
	    gp2.moveTo(x+w,y+d);
	    gp2.lineTo(x+d,y+0);
	}

	if(m==0) {
	    gp2.moveTo(x+w,y+d);
	    gp2.lineTo(x+d,y+w);
	    gp2.moveTo(x+0,y+d);
	    gp2.lineTo(x+d,y+0);
	}
	gp2=transform(gp2);

	Color C1=new Color(255,150,50);
	Color C2=Color.black;
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.draw(gp);
	g.setColor(new Color(0,0,200));
	g.setStroke(new BasicStroke(3));
	g.draw(gp2);
	g.setStroke(new BasicStroke(1));
    }


    public void drawShield(Graphics2D g,int k) {
	double w=1.0/k;
	Path2D.Double gp=new Path2D.Double();
	double d=w/2;

	gp.moveTo(w,w);
	gp.lineTo(w,.5+d);
	gp.lineTo(.5+d,w);
	gp.closePath();

	gp.moveTo(1,1);
	gp.lineTo(1,.5+d);
	gp.lineTo(.5+d,1);
	gp.closePath();

	gp.moveTo(w,1);
	gp.lineTo(w,.5+d);
	gp.lineTo(.5+d,1);
	gp.closePath();

	gp.moveTo(1,w);
	gp.lineTo(.5+d,w);
	gp.lineTo(1,.5+d);
	gp.closePath();


	gp=transform(gp);
	g.setColor(new Color(0,0,0,40));
	g.fill(gp);
    }



    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
	if(TOP.inside(JX)==1) return;
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  {
             SOURCE=unTransform(JX);
	}
	repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
         MouseData J=MouseData.process(e);
	 JX=J.X;
     }
  
     public void mouseDragged(MouseEvent e) {
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

