import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class manages the edge-plot sanity check.
This plot is very important in the understanding of
the coherence theorem from my first paper.  The idea
is that we pick a certain point in each square and
map it into the Plaid PET.  We color the image
point according as to whether or not it has a
P-particle or Q-particle in it.  The canonical choice
of point in the square is the center, but the console
also allows you to choose points on the centers of
the edges.*/


public class WallConsole {
    Manager M;
    int wall;
    int[] offset=new int[2];
    ControlPanel SLOPE,OFFSET,SYMM;
    ControlPanelColor HOR,VER;
    int X,Y;

    public WallConsole(int x,int y) {
	X=x;
	Y=y;
	setPanels();
    }

    public void setPanels() {

	Color[] A0={new Color(0,0,200),
                     Color.white,
                     Color.white,
		    Color.white,
                     Color.red};

         Color[] A1={new Color(200,0,0),
                     new Color(255,100,0),
		     new Color(0,0,200),
		     new Color(0,100,255)};

	 String[] SlopeString={
	     "ver",
	     "hor",
	     "slice"};
	 int[] SlopeState={1,0};
         SLOPE=new ControlPanel(A0,SlopeString,SlopeState,2);
	 SLOPE.mode=0;

	 String[] SymmString={
	     "all",
	     "symmetric",
	     "plot choice"};
	 int[] SymmState={1,0};
         SYMM=new ControlPanel(A0,SymmString,SymmState,2);
	 SYMM.mode=0;

	 String[] OffsetString={
	     "square",
	     "edge",
	     "offset"};
	 int[] OffsetState={1,0};
         OFFSET=new ControlPanel(A0,OffsetString,OffsetState,2);
	 OFFSET.mode=0;

	 String[] HorString={
	     "P north", 
             "P south",
	     "Q north",  
             "Q south",
	     "point type"};
	 int[] HorState={1,0,0,0};
         HOR=new ControlPanelColor(A0,HorString,HorState,4,A1);
	 HOR.mode=0;

	 String[] VerString={
	     "P east",
	     "P west",
	     "Q east",
	     "Q west",
	     "point type"};
	 int[] VerState={1,0,0,0};
         VER=new ControlPanelColor(A0,VerString,VerState,4,A1);
	 VER.mode=0;

    }

    public void render(Graphics2D g) {
	 SLOPE.render(g,X,Y,50);
	 OFFSET.render(g,X+55,Y,60);
	 SYMM.render(g,X,Y+140,115);
	 if(SLOPE.mode==0) VER.render(g,X,Y+55,115);
	 if(SLOPE.mode==1) HOR.render(g,X,Y+55,115);
    }

    public void process(Point X,Color C) {
	int t=0;
	t=SLOPE.switchMode(X);
	if(t==20) DocumentControl.particleSlice(M.D);
	t=OFFSET.switchMode(X);
	if(t==20) DocumentControl.particleOffset(M.D);
	t=SYMM.switchMode(X);
 	if(t==20) DocumentControl.particlePlot(M.D);
	if(SLOPE.mode==0) {
            t=VER.process(X,C);
	    if(t==20) DocumentControl.particleType(M.D);
	}
	if(SLOPE.mode==1) {
            t=HOR.process(X,C);
	    if(t==20) DocumentControl.particleType(M.D);
	}


    }


    /**This selects which points we apply the
       classifying map to.*/

    public double[] getOffset() {
	//square center
	if(OFFSET.mode==0) {
	    double[] t={.5,.5};
	    return t;
	}
	//west edge
	if(OFFSET.mode==1) {
	    if(SLOPE.mode==0) {
		double[] t={0,.5};  
                return t;
	    }
	}
	//south edge
	if(OFFSET.mode==1) {
	    if(SLOPE.mode==1) {
		double[] t={.5,0}; 
                return t;
	    }
	}
	return null;
    }
	   

    public int[] plotType(int j) {
	int[][] L={{0,0},{0,1},{1,0},{1,1}};
	int[] a=new int[4];
	for(int i=0;i<4;++i) {
	    if(SLOPE.mode==0) {
		if((i==j)&&(VER.L[j].on==1)) return L[j];
	    }
	    if(SLOPE.mode==1) {
		if((i==j)&&(HOR.L[j].on==1)) return L[j];
	    }
	}
	return null;
    }


    public Color plotColor(int j) {
	int[] a=new int[4];
	for(int i=0;i<4;++i) {
	    if(SLOPE.mode==0) {
		if((i==j)&&(VER.L[j].on==1)) return VER.M[j].C;
	    }
	    if(SLOPE.mode==1) {
		if((i==j)&&(HOR.L[j].on==1)) return HOR.M[j].C;
	    }
	}
	return null;
    }


    /**This plots the images of the particles, for each of
       the 8 types of particles*/

    public void draw(Graphics2D g,PlaidPETCanvas PET) {
	if(SYMM.mode==0) drawAll(g,PET);
	if(SYMM.mode==1) {
	    if(SLOPE.mode==0) drawSymmVertical(g,PET);
	    if(SLOPE.mode==1) drawSymmHorizontal(g,PET);
	}
    }


    public void drawAll(Graphics2D g,PlaidPETCanvas PET) {

	Path2D.Double gp=new Path2D.Double();
	int p=PET.M.C.PAR.getNumerator();
	int q=PET.M.C.PAR.getDenominator();
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	int k=p+q;
	Tile T=new Tile();
	double[] o=getOffset();

	double min=PET.M.QS.getSlice()-1.0/(p+q);
	double max=min+2.0/(p+q);
	int ch=SLOPE.mode; 

        for(int i=0;i<k*k;++i) {
	    for(int j=0;j<2*k;++j) {
		Vector4 V=PlaidClassifyingMap.PHI(A,i+o[0],j+o[1]);
	        if((V.x[0]>min)&&(V.x[0]<max)) {
                  T=new Tile(p,q,i,j);
                  T.type();
		  for(int k1=0;k1<4;++k1) {
		      int[] k2=plotType(k1);
		      Color COL=plotColor(k1);
		      if(k2!=null) {
		         int a=T.rawSigned[1-ch][k2[0]][k2[1]];
			 if(a!=0) {
                            gp=makeSquare(p,q,V.x[1],V.x[2]);  
			    g.setColor(COL);
		            gp=PET.transform(gp);
		            g.fill(gp);
			 }
		      }
		  }
		}
	    }
	}
    }


    public void drawSymmVertical(Graphics2D g,PlaidPETCanvas PET) {
	Path2D.Double gp=new Path2D.Double();
	int p=PET.M.C.PAR.getNumerator();
	int q=PET.M.C.PAR.getDenominator();
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	int k=p+q;
	Tile T=new Tile();
	double[] o=getOffset();

	double min=PET.M.QS.getSlice()-1.0/(p+q);
	double max=min+2.0/(p+q);
	int ch=SLOPE.mode; 

	int[] y={(k-1)/2,-(k-1)/2-1};
        for(int i=0;i<k*k;++i) {
	    for(int j=0;j<2;++j) {
	      Vector4 V=PlaidClassifyingMap.PHI(A,i+o[0],y[j]+o[1]);
              T=new Tile(p,q,i,y[j]);
              T.type();
	      for(int k1=0;k1<4;++k1) {
	        int[] k2=plotType(k1);
	        Color COL=plotColor(k1);
	        if(k2!=null) {
	           int a=T.rawSigned[1-ch][k2[0]][k2[1]];
	           if(a!=0) {
		     gp=makeSquare(p,q,V.x[0],V.x[1]);  
	             g.setColor(COL);
	             gp=PET.transform(gp);
	             g.fill(gp);
		 }
		}
	      }
	    }
	}
    }


    public void drawSymmHorizontal(Graphics2D g,PlaidPETCanvas PET) {
	Path2D.Double gp=new Path2D.Double();
	int p=PET.M.C.PAR.getNumerator();
	int q=PET.M.C.PAR.getDenominator();
	double A=1.0*p/q;
	double P=2.0*p/(p+q);
	int k=p+q;
	Tile T=new Tile();
	double[] o=getOffset();

	double min=PET.M.QS.getSlice()-1.0/(p+q);
	double max=min+2.0/(p+q);
	int ch=SLOPE.mode; 

        for(int i=0;i<k;++i) {
	    for(int j=-k;j<k;++j) {
		int x=(k-1)/2+k*i;
		Vector4 V=PlaidClassifyingMap.PHI(A,x+o[0],j+o[1]);
              T=new Tile(p,q,x,j);
              T.type();
	      for(int k1=0;k1<4;++k1) {
	        int[] k2=plotType(k1);
	        Color COL=plotColor(k1);
	        if(k2!=null) {
	           int a=T.rawSigned[1-ch][k2[0]][k2[1]];
	           if(a!=0) {
		     gp=makeSquare(p,q,V.x[1],V.x[2]);  
	             g.setColor(COL);
		     if(V.x[0]<-.5) g.setColor(Color.white);
	             gp=PET.transform(gp);
	             g.fill(gp);
		 }
		}
	      }
	    }
	}
    }


    public Path2D.Double makeSquare(int p,int q,double x0,double x1) {
	Path2D.Double gp=new Path2D.Double();
	double y=1.0/(p+q);
	gp.moveTo(x0-y,x1-y);
	gp.lineTo(x0+y,x1-y);
	gp.lineTo(x0+y,x1+y);
	gp.lineTo(x0-y,x1+y);
	gp.closePath();
	return(gp);
    }


}


