import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class retrieves the the polytopes from the 4 partitions:
   graph partition
   plaid partition
   clean partition
   Z partition
In the graph and plaid and Z partitions the polytopes are scaled up by 60.
In the clean partition the polytopes have already been scaled up by 60
so that the vertices are integers.*/


public class AllPolytopesLong {



    public static PolytopeLong graph(int k) {
	int[][] P1=DataGraphPolytopes.data(k);
	PolytopeLong X=new PolytopeLong();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4Long(60*P1[i][0],60*P1[i][1],60*P1[i][2],60*P1[i][3]);
	}
	int[] type=DataGraphPolytopes.type(k);
	X.type[1]=type[0];
	X.type[2]=type[1];
	return(X);
    }



    public static PolytopeLong plaid(int k) {
	int[][] P1=DataPlaidPolytopes.data(k);
	PolytopeLong X=new PolytopeLong();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4Long(60*P1[i][0],60*P1[i][1],60*P1[i][2],60*P1[i][3]);
	}
	int[] type=DataPlaidPolytopes.type(k);
	X.type[1]=type[0];
	X.type[2]=type[1];
	return(X);
    }


    /**We store half the polytopes, the ones in Z+, and
       we get the other half by applying the map I*/

    public static PolytopeLong clean(int k) {
	int k2=(k%95);  
	int[][] P1=DataCleanPartition.data(k2);
	PolytopeLong X=new PolytopeLong();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4Long(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	int[] type=DataCleanPartition.type(k2);
	X.type[1]=type[0];
	X.type[2]=type[1];
	for(int i=0;i<4;++i) X.code[i]=type[i];
	if(k>=95) return DynamicsPlaid.I(X);
	return(X);
    }


    public static PolytopeLong ZnotScaled(int k) {
	int[][] P1=DataZPartition.data(k);
	PolytopeLong X=new PolytopeLong();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4Long(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	return(X);
    }



    /**this takes the fundamental domain in Z(k)
       for the action of the covering group.*/

    public static PolytopeLong Zsmall(int k) {
	PolytopeLong P=ZnotScaled(k);
	for(int i=0;i<P.count;++i) {
	   for(int j=0;j<4;++j) {
	       if(j!=2) P.V[i].x[j]=P.V[i].x[j]*60;
	       if(j==2) P.V[i].x[j]=P.V[i].x[j]*6;
	   }
	}
	return P;
    }


    public static PolytopeLong Zbig(int k) {
	PolytopeLong P=ZnotScaled(k);
	for(int i=0;i<P.count;++i) {
	   for(int j=0;j<4;++j) {
	       P.V[i].x[j]=P.V[i].x[j]*60;
	   }
	}
	return P;
    }






}
