import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends Canvas implements MouseListener {
    ControlPanel MAIN,WORD;
    ListenSquare GO,STOP;

     public ControlCanvas() {
	 addMouseListener(this);
	 setPanels();
	 GO=new ListenSquare(0,210,30,25);
     }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,0,100));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawControls(Graphics2D g) { 
	MAIN.render(g,0,0,115); 
	WORD.render(g,0,135,115); 
         g.setFont(new Font("Helvetica",Font.PLAIN,14));
         GO.render(g,new Color(0,200,0)); 
         g.drawString("go",(int)(GO.x+5),(int)(GO.y+18));
    }

    public void doGo() {
	long time1=System.currentTimeMillis();
	int choice=MAIN.mode;
	if(MAIN.L[0].on==1) ProofConvex.main();
	if(MAIN.L[1].on==1) ProofPartition.main();
	if(MAIN.L[2].on==1) ProofClean.main();
	if(MAIN.L[3].on==1) ProofDynLarge.main();
	if(MAIN.L[4].on==1) ProofOrbitEquiv1.main();
	if(MAIN.L[5].on==1) ProofOrbitEquiv2.main();
	if(MAIN.L[6].on==1) ProofSquare.main();

	long time2=System.currentTimeMillis();
	long time=time2-time1;
	System.out.println("total time "+time);
    }




    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e); 
	MAIN.toggle(J.X);
	WORD.switchMode(J.X);
	if(WORD.mode==0) Verbose.WORD=false;
	if(WORD.mode==1) Verbose.WORD=true;
        if(GO.inside(J.X)==1) doGo();
	repaint();
    }


    public void mousePressed(MouseEvent e) {
    }
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   


    public void setPanels() {

         Color[] C={new Color(200,0,255),
                     Color.white,
                     Color.white,
                     Color.black,
                     Color.yellow};

	 String[] MainString={
	    "prove tight convex",
	    "prove partition",
	    "prove clean",
	    "prove dyn large",
	    "prove orbit equiv 1",
	    "prove orbit equiv 2",
	    "prove square",
            "proofs"};
	 int[] MainState={1,1,1,1,1,1,1};
         MAIN=new ControlPanel(C,MainString,MainState,7);

	 String[] WordString={
	     "taciturn",
	     "verbose",
            "running style"};
	 int[] WordState={1,0};
         WORD=new ControlPanel(C,WordString,WordState,2);
    }

}

