public class DataGraphPolytopes {

    /**Notes:  This is the forward partition for the graph PET.  
       The backwards partition is obtained by the following moves:
       if(k<14) P->GraphPolytopeMoves.shift(+1,1,1,P);
       if(k>13) P->GraphPolytopeMoves.shift(-1,0,0,P);
       In the backward case the union of the polytopes is not
       a convex polytope like it is in the forward case.
       However, when we project to the torus both polytope unions
       really are partitions.*/

public static int[][] data(int k) {
    int[][][] P={{{0,-1,0,0},{0,0,0,0},{0,0,0,1},{0,1,0,1},{1,1,0,1},{0,0,1,1},{1,0,1,1},{1,1,1,1}},{{0,-1,0,0},{0,-1,0,1},{1,-1,0,0},{0,0,0,1},{1,0,0,1},{0,-1,1,1},{1,-1,1,0},{1,-1,1,1},{1,0,1,1}},{{0,0,0,0},{1,0,0,0},{1,0,1,0},{1,0,1,1},{1,1,1,1},{1,0,2,1}},{{0,0,0,0},{0,1,0,1},{0,-1,1,0},{0,0,1,0},{0,0,1,1},{1,0,1,0},{0,1,1,1},{1,1,1,1}},{{0,-1,0,0},{1,-1,0,0},{0,0,0,1},{1,0,0,0},{1,0,0,1},{1,1,0,1},{1,-1,1,0},{1,0,1,1}},{{0,-1,0,0},{0,0,0,1},{0,-1,1,1},{0,0,1,1},{1,0,1,1}},{{0,-1,0,1},{1,-1,0,0},{1,-1,0,1},{1,0,0,1},{1,-1,1,1}},{{0,-1,0,0},{0,0,0,0},{1,0,0,0},{1,1,0,1},{1,0,1,1},{1,1,1,1}},{{0,0,1,0},{0,1,1,1},{0,0,2,1},{0,1,2,1},{1,1,2,1}},{{0,0,0,0},{0,0,1,1},{1,0,1,1},{1,1,1,1},{1,0,2,1}},{{0,-1,1,0},{0,0,1,0},{0,0,1,1},{1,0,1,0},{0,-1,2,1},{0,0,2,1},{1,0,2,1}},{{0,-1,1,1},{1,-1,1,0},{1,-1,1,1},{1,0,1,1},{1,-1,2,1}},{{0,-1,0,0},{0,0,0,0},{1,0,0,0},{0,-1,1,0},{0,-1,1,1},{1,-1,1,0},{0,0,1,1},{1,0,1,0},{1,0,1,1},{0,-1,2,1},{1,-1,2,1},{1,0,2,1}},{{0,0,1,0},{0,0,1,1},{1,0,1,0},{0,1,1,1},{1,1,1,1},{0,0,2,1},{1,0,2,1},{1,1,2,1}},{{2,0,1,0},{2,-1,1,0},{2,0,2,1},{2,-1,2,1},{1,-1,2,1},{2,0,1,1},{1,0,1,1},{1,-1,1,1}},{{2,0,1,0},{2,1,2,1},{1,0,1,0},{2,0,2,1},{1,0,2,1},{2,1,1,1},{1,0,0,0},{1,1,1,1},{1,0,1,1}},{{2,-1,1,0},{1,-1,1,0},{1,-1,0,0},{1,0,1,1},{1,-1,1,1},{1,0,0,1}},{{2,-1,1,0},{2,-1,2,1},{2,0,0,0},{2,-1,0,0},{2,0,1,1},{1,-1,0,0},{2,-1,1,1},{1,-1,1,1}},{{2,0,1,0},{1,0,1,0},{2,0,2,1},{1,-1,1,0},{1,0,2,1},{1,-1,2,1},{1,0,0,0},{1,0,1,1}},{{2,0,1,0},{2,0,2,1},{2,1,1,1},{2,0,1,1},{1,0,1,1}},{{2,1,2,1},{1,0,1,0},{1,1,2,1},{1,0,2,1},{1,1,1,1}},{{2,0,1,0},{2,-1,1,0},{1,-1,1,0},{1,-1,2,1},{1,0,1,1},{1,-1,1,1}},{{2,-1,0,0},{2,-1,1,1},{2,0,0,1},{2,-1,0,1},{1,-1,0,1}},{{2,-1,1,0},{2,0,1,1},{1,0,1,1},{1,-1,1,1},{1,0,0,1}},{{2,0,0,0},{2,-1,0,0},{2,0,1,1},{1,-1,0,0},{2,1,0,1},{2,0,0,1},{1,0,0,1}},{{2,1,1,1},{1,0,0,0},{1,1,1,1},{1,0,1,1},{1,1,0,1}},{{2,0,1,0},{2,-1,1,0},{1,-1,1,0},{2,0,0,0},{2,1,1,1},{1,0,0,0},{2,0,1,1},{1,-1,0,0},{1,0,1,1},{2,1,0,1},{1,1,0,1},{1,0,0,1}},{{2,-1,0,0},{2,0,1,1},{1,-1,0,0},{2,-1,1,1},{1,-1,1,1},{2,0,0,1},{1,0,0,1},{1,-1,0,1}}};
    return P[k];
}

    /**These are the types for the polytopes, as in the Graph Master Picture Theorem.*/

public static int[] type(int k) {
int[][] P={{-1,1},{1,1},{-1,-1},{0,1},{0,1},{0,1},{0,1},{-1,0},{-1,0},{-1,0},{1,0},{1,0},{0,0},{0,0},{1,-1},{-1,-1},{1,1},{0,-1},{0,-1},{0,-1},{0,-1},{1,0},{1,0},{1,0},{-1,0},{-1,0},{0,0},{0,0}};
return P[k];
}

}
