import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This file does the graph PET dynamics and also
   shifts the graph PET polytopes according to the
   action of the graph covering group.*/

 public class DynamicsGraph {

     /**This does the forward map.  Here (m1,m2) is the type
        of the vector.  This is precomputed with the polytope.
        This only computes the map modulo the covering group. 
        We don't explicitly reduce to a fundamental domain.*/


    public static PolytopeLong F(PolytopeLong X) {
	int m1=X.type[1];
	int m2=X.type[2];
	PolytopeLong Y=new PolytopeLong();
	Y.count=X.count;
	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=graphMap(m1,m2,X.V[i]);
	}
	return Y;
    }

     public static Vector4Long graphMap(int m1,int m2,Vector4Long V0) {
	long A=V0.x[3];
        long d0=m1*A+60*m2+60*(m2-m1);
	long d1=m1*A+60*m2-60*(m2-m1);
	long d2=m1*A+60*m2-60*(m2-m1);
	Vector4Long V1=Vector4Long.plus(V0,new Vector4Long(d0,d1,d2,0));
	return V1;
    }


    /**These are just like what we do for the real polytopes but here the maps
       are conjugated by 60-dilation.  This is the action of the graph PET
       lattice on the graph PET polytopes. */

    public static PolytopeLong graphShift(int q1,int q2,int q3,PolytopeLong P) {
	PolytopeLong Q=new PolytopeLong(P);
	Q=graphShift1(q1,Q);
	Q=graphShift2(q2,Q);
	Q=graphShift3(q3,Q);
	for(int i=0;i<6;++i) Q.code[i]=P.code[i];
	return(Q);
    }

    public static PolytopeLong graphShift1(int m,PolytopeLong P) {
	PolytopeLong Q=new PolytopeLong();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.V[i]=Vector4Long.plus(P.V[i],new Vector4Long(60*m,-60*m,-60*m,0));
	}
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }


    public static PolytopeLong graphShift2(int m,PolytopeLong P) {
	PolytopeLong Q=new PolytopeLong();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.V[i]=Vector4Long.plus(P.V[i],new Vector4Long(0,m*P.V[i].x[3]+60*m,-m*P.V[i].x[3]+60*m,0));
	}
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }

    public static PolytopeLong graphShift3(int m,PolytopeLong P) {
	PolytopeLong Q=new PolytopeLong();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
	    Q.V[i]=Vector4Long.plus(P.V[i],new Vector4Long(0,0,m*P.V[i].x[3]+60*m,0));
	}
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }



}
