import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DynamicsPlaid {



    /**Here is the plaid PET map F_X.  Here we have
       power=0,1,2.  The two variables X.code[1] and X.code[3]
       determine the map. When X.code[0]=X.code[1], the PET
       dynamics fixes the polytope.*/

    public static PolytopeLong F(int power,PolytopeLong X) {
	if(power==0) return X;
	if(X.code[0]==X.code[1]) return X;

	PolytopeLong Y=new PolytopeLong();
	Y.count=X.count;
	int k=X.code[1];
	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=plaidMap(k,X.V[i]);
	}
	if(power==1) return Y;
	k=X.code[3];
	PolytopeLong Z=new PolytopeLong(Y);
	for(int i=0;i<Y.count;++i) {
	    Z.V[i]=plaidMap(k,Y.V[i]);
	}
	return Z;
    }

    /**The maps comprising the main ones*/

    public static Vector4Long plaidMap(int k,Vector4Long V) {
	if(k==0) return plaidMap0(V);
	if(k==1) return plaidMap1(V);
	if(k==2) return plaidMap2(V);
	if(k==3) return plaidMap3(V);
	return null;
    }

    public static Vector4Long plaidMap0(Vector4Long V) {
	Vector4Long W=new Vector4Long();
	W.x[0]=V.x[0]-120;
	W.x[1]=V.x[1];
	W.x[2]=V.x[2]-2*V.x[3];	
        W.x[3]=V.x[3];
	return(W);
    }

    public static Vector4Long plaidMap1(Vector4Long V) {
	Vector4Long W=new Vector4Long();
	W.x[0]=V.x[0]-2*V.x[3];
	W.x[1]=V.x[1]-2*V.x[3];
	W.x[2]=V.x[2]-2*V.x[3];	
        W.x[3]=V.x[3];
	return(W);
    }

    public static Vector4Long plaidMap2(Vector4Long V) {
	Vector4Long W=new Vector4Long();
	W.x[0]=V.x[0]+120;
	W.x[1]=V.x[1];
	W.x[2]=V.x[2]+2*V.x[3];
	W.x[3]=V.x[3];
	return(W);
    }

    public static Vector4Long plaidMap3(Vector4Long V) {
	Vector4Long W=new Vector4Long();
	W.x[0]=V.x[0]+2*V.x[3];
	W.x[1]=V.x[1]+2*V.x[3];
	W.x[2]=V.x[2]+2*V.x[3];
 	W.x[3]=V.x[3];
	return(W);
    }


    /**Here is the action of the plaid PET lattice on the plaid PET
       polytopes. Again, the original maps are conjugated by a factor
       of 60, to clear denominators.*/


    public static PolytopeLong plaidShift(int a1,int a2,int a3,PolytopeLong X) {
	PolytopeLong Y=new PolytopeLong();
	Y.count=X.count;
	for(int i=0;i<X.count;++i) {
	    Y.V[i]=plaidShift(a1,a2,a3,X.V[i]);
	}

	if((10+a1)%2==1) {
	  Y.type[1]=X.type[2];
  	  Y.type[2]=X.type[1];
	}
	else {
	  Y.type[1]=X.type[1];
  	  Y.type[2]=X.type[2];
	}
	return(Y);
    }

    public static Vector4Long plaidShift(int a1,int a2,int a3,Vector4Long V) {
	Vector4Long W=new Vector4Long();
	long x=V.x[0];
	long y=V.x[1];
	long z=V.x[2];
	long P=V.x[3];
	W.x[0]=120*a1+x;
	W.x[1]=P*a1+120*a2+y;
	W.x[2]=P*a1+120*a3+z;
	W.x[3]=P;
	return(W);
    }


    /***This does the reflection symmetry*/

    public static PolytopeLong I(PolytopeLong P) {
	PolytopeLong Q=new PolytopeLong(P);
	for(int i=0;i<P.count;++i) {
	    Q.V[i]=I(P.V[i]);
	}
	for(int i=0;i<4;++i) Q.code[i]=(2+P.code[i])%4;
	for(int i=1;i<3;++i) Q.type[i]=(2+P.type[i])%4;
	return Q;
    }

    public static Vector4Long I(Vector4Long V) {
	Vector4Long W=V.scale(-1);
	W.x[3]=-W.x[3];
	return W;
    }


}
