import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This does the action of the intertwining map omega,
   from the graph PET to the plaid PET*/

public class PlaidToGraph {


    /**The main routine*/

    public static PolytopeLong omega(PolytopeLong P) {
	int[] x=ZComponent(P);
	int guide=x[2];  
	PolytopeLong Q=translateBack(x,P);
	PolytopeLong R=new PolytopeLong(Q);
	for(int i=0;i<R.count;++i) {
	    R.V[i]=omega(guide,Q.V[i]);
	}
	return R;
    }


    /**This routine assumes that U is in one of 
       the basic pieces.  The vector we are looking
       for has the form V/d.  We can't always do this
       division over the longs, so we keep track of
       the pair (V,d) and deal with the division later.*/


    public static Vector4Long  omega(int guide,Vector4Long U) {
	long P=U.x[3];
	Vector4Long H1=new Vector4Long(U.x[0]-U.x[1],-U.x[1],U.x[2],P);
	Vector4Long H2=new Vector4Long(0,0,0,0);
	if(guide==0) H2=new Vector4Long(-120+P,+60,-60-P,0);  
	if(guide==1) H2=new Vector4Long(+120-P,-60,+60+P,0);  
	Vector4Long H3=Vector4Long.plus(H1,H2);
	H3=H3.scale(60);
	H3.denominator=120-P;
	H3=H3.legalSimplify();
	return H3;
    }

    /**This routine translates the polytope back to one
       of the routines Z+, Z-, Z'+, Z'-*/

    public static PolytopeLong translateBack(int[] x,PolytopeLong P) {
	int k0=x[0];
	int k1=x[1];
        PolytopeLong Q=DynamicsPlaid.plaidShift(-2*k0,-k1,0,P);
	return Q;
    }

    /**This routine finds the component of the
       Z partition containing the polytope.*/

    public static int[] ZComponent(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<2;++i) {
	    PolytopeLong Q0=AllPolytopesLong.Zbig(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
		PolytopeLong Q=DynamicsPlaid.plaidShift(2*k0,k1,0,Q0);
		if(Q.contains(P)) {
		    int[] x={k0,k1,i};
		    return x;
		}
	    }}}}
	    return null;
	}



}




