import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class deals with integer polytopes*/

public class PolytopeLong {
    int count;
    Vector4Long[] V=new Vector4Long[200];
    int[] type=new int[4];
    int[] code=new int[6];
    int zone;

    public PolytopeLong() {}

    public PolytopeLong(PolytopeLong P) {
	count=P.count;
	for(int i=0;i<P.count;++i) {
	    V[i]=new Vector4Long(P.V[i]);
	}
	for(int i=0;i<3;++i) type[i]=P.type[i];
	for(int i=0;i<6;++i) code[i]=P.code[i];
    }

    public PolytopeLong(Vector4Long[] F) {
	count=F.length;
	for(int i=0;i<F.length;++i) {
	    V[i]=new Vector4Long(F[i]);
	}
    }


    public PolytopeLong shift(Vector4Long W) {
	PolytopeLong Q=new PolytopeLong();
	for(int i=0;i<count;++i) {
	    Q.V[i]=Vector4Long.plus(V[i],W);
	}
	Q.count=count;
	Q.type[0]=type[0];
	Q.type[1]=type[1];
	Q.type[2]=type[2];
	return(Q);
    }

    public void print() {
	System.out.println("PolytopeLong");
	for(int i=0;i<count;++i) V[i].print();
	System.out.println(type[1]+" "+type[2]);
    }

    public void printRational() {
	System.out.println("PolytopeLong");
	for(int i=0;i<count;++i) V[i].printRational();
	System.out.println(type[1]+" "+type[2]);
    }






    /**This routine tells if one convex integer polytope contains another one.  It is an exact test.*/

    public boolean contains(PolytopeLong P) {
	for(int i=0;i<P.count;++i) {
	    if(contains(P.V[i])==false) return false;
	}
	return true;
    }


    /**This tests if the polytope contains the point.  It suffices to check that the point is NOT extreme for any of the linear functionals defined by the normals to the faces of the polytope.  This is a routine that is guaranteed in the absence of overflow error.*/

    public boolean contains(Vector4Long X) {
	Vector4Long[] TEST=this.normals();
	for(int i=0;i<TEST.length;++i) {
	    if(isExtreme(TEST[i],X)==true) return false;
	}
	return true;
    }


    /**This gets an integer normal vector to the face of the polytope
       with the given indices.  In the degenerate case, the vector is 0.
       The notion of face here is general. It doesn't have to be a boundary
       face; just the convex hull of 4 vertices.*/

    public Vector4Long normal(int i,int j0,int j1,int j2) {
	   Vector4Long[] X=new Vector4Long[3];
	   X[0]=Vector4Long.minus(V[j0],V[i]);
	   X[1]=Vector4Long.minus(V[j1],V[i]);
	   X[2]=Vector4Long.minus(V[j2],V[i]);
	   return Vector4Long.perp(X);
    }

    /**this gets the list of all generalized normals*/
    public Vector4Long[] normals() {
	int n=this.count;
	int count=0;
	Vector4Long[] LIST=new Vector4Long[n*n*n];
	for(int i=0;i<n;++i) {
	    for(int j0=i+1;j0<n;++j0) {
	    for(int j1=j0+1;j1<n;++j1) {
	    for(int j2=j1+1;j2<n;++j2) {
		Vector4Long W=this.normal(i,j0,j1,j2);
		if(W.isZero()==false) {
		    if(ListHelp.onListWide(W,LIST,count)==false) {
		      LIST[count]=new Vector4Long(W);
		      ++count;
		    }
		}
	    }}}
	}
	return ListHelp.trim(LIST,count);
    }


    /**This tests if a point is extreme relative to a polytope and a chosen auxilliary linear functional*/

    public boolean isExtreme(Vector4Long TEST,Vector4Long X) {
	long x=Vector4Long.dot(TEST,X);
	long min=x+1;
	long max=x-1;
	for(int i=0;i<count;++i) {
	    long test=Vector4Long.dot(TEST,V[i]);
	    if(min>test) min=test;
	    if(max<test) max=test;
	}
	if(x<min) return true;
	if(x>max) return true;
	return false;
    }
    /**End of polytope containment test*/




    /**This tests if two polytopes have disjoint interiors. The idea is to find a linear functional which separates them.  Given the simple nature of our polytopes, we only check a smallish number of linear functionals before declaring failure*/


    public boolean isDisjoint(PolytopeLong Q) {
	for(int i0=-5;i0<=5;++i0) {
	for(int i1=-5;i1<=5;++i1) {
	for(int i2=-5;i2<=5;++i2) {
	for(int i3=-5;i3<=5;++i3) {
	    Vector4Long TEST=new Vector4Long(i0,i1,i2,i3);
	    boolean test=separates(TEST,Q);
	    if(TEST.isZero()==true) test=false;
	    if(test==true) return true;
	}}}}
	return false;
    }

    public boolean separates(Vector4Long TEST,PolytopeLong Q) {
	long max=this.max(TEST);
	long min=Q.min(TEST);
	if(max<=min) return true;
	return false;
    }

    /**Gets the maximum value of a linear functional*/
    public long max(Vector4Long TEST) {
	long m=Vector4Long.dot(TEST,V[0]);
	for(int i=1;i<count;++i) {
	    long test=Vector4Long.dot(TEST,V[i]);
	    if(m<test) m=test;
	}
	return m;
    }

    /**Gets the minimum value of a linear functional*/
    public long min(Vector4Long TEST) {
	long m=Vector4Long.dot(TEST,V[0]);
	for(int i=1;i<count;++i) {
	    long test=Vector4Long.dot(TEST,V[i]);
	    if(m>test) m=test;
	}
	return m;
    }



    /**This tests whether a polytope is cleanly convex. This
       means that each vertex is a strict extreme point.*/

    public boolean isTightConvex() {
	for(int k=0;k<count;++k) {
	    boolean test=strictExtreme(k);
	    if(test==false) { 
		System.out.println("not extreme "+k);
                return false;
	    }
	}
	return true;
    }

    public boolean strictExtreme(int k) {
	for(int i0=-5;i0<=5;++i0) {
	for(int i1=-5;i1<=5;++i1) {
	for(int i2=-5;i2<=5;++i2) {
	for(int i3=-5;i3<=5;++i3) {
	    Vector4Long TEST=new Vector4Long(i0,i1,i2,i3);
	    boolean test=strictExtreme(TEST,k);
	    if(test==true) return true;
	}}}}
	return false;

    }

    public boolean strictExtreme(Vector4Long TEST,int k) {
	long a=Vector4Long.dot(TEST,V[k]);
	for(int i=0;i<count;++i) {
	    long test=Vector4Long.dot(TEST,V[i]);
	    if((i!=k)&&(test>=a)) return false;
	}
	return true;
    }



}












