import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class deals with integer polytopes*/

public class PolytopeLongVolume {


    /**This computes 48 times the volume of a 4D integer convex polytope.
       The assumption is that all the codimension 2 faces are either
       triangles or quadrilaterals*/

    public static long volume(PolytopeLong P1) {
	long total=0;
	Vector4Long CONE0=new Vector4Long(P1.V[0]);

	Vector4Long[][] F1=faceList1(P1);

	for(int i1=0;i1<F1.length;++i1) {
	    PolytopeLong P2=new PolytopeLong(F1[i1]);
	    Vector4Long CONE1=new Vector4Long(P2.V[0]);
	    Vector4Long[][] F2=faceList2(P2);

	    for(int i2=0;i2<F2.length;++i2) {
	       PolytopeLong P3=new PolytopeLong(F2[i2]);
	       Vector4Long[][] TRI=extractTriangles(P3);
	       for(int i3=0;i3<TRI.length;++i3) {
		   Vector4Long[] PENTA={CONE0,CONE1,TRI[i3][0],TRI[i3][1],TRI[i3][2]};
		   PolytopeLong SIMPLEX=new PolytopeLong(PENTA);
		   total=total+vol24(SIMPLEX);
	       }
	    }
	}
	return(total);
    }


    /**This computes 24 times the volume of a 4-simplex*/
    public static long vol24(PolytopeLong P) {
	Vector4Long[] X=new Vector4Long[4];
	for(int i=0;i<4;++i) X[i]=Vector4Long.minus(P.V[i],P.V[4]);
	Vector4Long U=Vector4Long.perp(X);
	long v=Vector4Long.dot(U,X[3]);
	if(v<0) v=-v;
	return(v);
    }

    /**The input to this routine is a triangle or quadrilateral contained in R4.
       In case there is a quadrilateral, the 4 points are known to be coplanar.
       In the case of triangles, we extract the list of vectors twice, getting 2 
       identical triangles.  In the case of quads, we get the list of all possible
       triangles made from 3 of the 4 points. So, in both cases, we are producing
       a 2-covering of the original polygon by triangles.*/

    public static Vector4Long[][] extractTriangles(PolytopeLong P) {
	if(P.count<3) throw new ProofException("extract triangles: too few vertices");
	if(P.count>4) throw new ProofException("extract triangles: too many vertices");
	if(P.count==3) {
	    Vector4Long[] X={P.V[0],P.V[1],P.V[2]};
	    Vector4Long[][] Y={X,X};
	    return(Y);
	}
	/**Checks coplanarity*/
	Vector4Long U=getNormal(P);
	if(U!=null) throw new ProofException("extract triangles: not coplanar");
	Vector4Long[] X0={P.V[1],P.V[2],P.V[3]};
	Vector4Long[] X1={P.V[2],P.V[3],P.V[0]};
	Vector4Long[] X2={P.V[3],P.V[0],P.V[1]};
	Vector4Long[] X3={P.V[0],P.V[1],P.V[2]};
	Vector4Long[][] Y={X0,X1,X2,X3};
	return Y;
    }


    /**This extracts the faces of a polytope.*/

    public static Vector4Long[][] faceList1(PolytopeLong P) {
	Vector4Long[] TEST=normalsPM(P);
	Vector4Long[][] FACE=new Vector4Long[TEST.length][10];
	int count2=0;
	for(int i=0;i<TEST.length;++i) {
	    Vector4Long TEST1=new Vector4Long(TEST[i]);
	    Vector4Long[] EX=extremeList(TEST1,P);
	    if(realPolyhedron(EX)==true) {
		if(ListHelp.onListNarrow(EX,FACE,count2)==false) {
		   FACE[count2]=EX;
		   ++count2;
		}
	    }  
	}
	Vector4Long[][] FACE2=new Vector4Long[count2][10];
	for(int i=0;i<FACE2.length;++i) {
	    FACE2[i]=ListHelp.trim(FACE[i],FACE[i].length);
	}
	return FACE2;
    }


    /**This checks that the vectors are the vertices of a
       truly 3-dimensional polyhedron*/

    public static boolean realPolyhedron(Vector4Long[] EX) {
	if(EX.length<4) return false;
	PolytopeLong P=new PolytopeLong(EX);
	Vector4Long U=getNormal(P);
	if(U==null) return false;
	return true;
    }

    /**This extracts the faces of a polytope face.*/

    public static Vector4Long[][] faceList2(PolytopeLong P) {
	Vector4Long[] TEST=faceNormalsPM(P);

	Vector4Long[][] FACE=new Vector4Long[TEST.length][10];
	int count2=0;
	for(int i=0;i<TEST.length;++i) {
	    Vector4Long TEST1=new Vector4Long(TEST[i]);
	    Vector4Long[] EX=extremeList(TEST1,P);
	    int t1=EX.length;
	    if((t1>=3)&&(t1<P.count)) {
		if(ListHelp.onListNarrow(EX,FACE,count2)==false) {
		   FACE[count2]=EX;
		   ++count2;
		}
	    }  
	}
	Vector4Long[][] FACE2=new Vector4Long[count2][10];
	for(int i=0;i<FACE2.length;++i) {
	    FACE2[i]=ListHelp.trim(FACE[i],FACE[i].length);
	}
	return FACE2;
    }


    /**Extreme values of linear functionals*/

    public static Vector4Long[] extremeList(Vector4Long TEST,PolytopeLong P) {
	int count2=0;
	Vector4Long[] W=new Vector4Long[P.count];
	long max=extremeValue(TEST,P);
	for(int i=0;i<P.count;++i) {
	    long test=Vector4Long.dot(TEST,P.V[i]);
	    if(test==max) {
		W[count2]=new Vector4Long(P.V[i]);
		++count2;
	    }
	}
	W=ListHelp.trim(W,count2);
	return W;
    }



    public static long extremeValue(Vector4Long TEST,PolytopeLong P) {
	long max=Vector4Long.dot(TEST,P.V[0]);
	for(int i=0;i<P.count;++i) {
	    long test=Vector4Long.dot(TEST,P.V[i]);
	    if(max<test) max=test;
	}
	return max;
    }




    /**This gets the original list of normals and then include the
       negative of each vector on the list*/

    public static Vector4Long[] normalsPM(PolytopeLong P) {
	Vector4Long[] LIST1=normals(P);
	Vector4Long[] LIST2=new Vector4Long[2*LIST1.length];
	for(int i=0;i<LIST1.length;++i) {
	    LIST2[2*i+0]=new Vector4Long(LIST1[i]);
	    LIST2[2*i+1]=Vector4Long.minus(new Vector4Long(0,0,0,0),LIST1[i]);
	}
	return(LIST2);
    }


    public static Vector4Long normal(PolytopeLong P,int i,int j0,int j1,int j2) {
	   Vector4Long[] X=new Vector4Long[3];
	   X[0]=Vector4Long.minus(P.V[j0],P.V[i]);
	   X[1]=Vector4Long.minus(P.V[j1],P.V[i]);
	   X[2]=Vector4Long.minus(P.V[j2],P.V[i]);
	   return Vector4Long.perp(X);
    }

    /**this gets the list of all generalized normals*/
    public static Vector4Long[] normals(PolytopeLong P) {
	int n=P.count;
	int count=0;
	Vector4Long[] LIST=new Vector4Long[n*n*n];
	for(int i=0;i<n;++i) {
	    for(int j0=i+1;j0<n;++j0) {
	    for(int j1=j0+1;j1<n;++j1) {
	    for(int j2=j1+1;j2<n;++j2) {
		Vector4Long W=normal(P,i,j0,j1,j2);
		if(W.isZero()==false) {
		    if(ListHelp.onListWide(W,LIST,count)==false) {
		      LIST[count]=new Vector4Long(W);
		      ++count;
		    }
		}
	    }}}
	}
	return ListHelp.trim(LIST,count);
    }


    /**This routine is applied to a polytope which is the
       face of a 4D polytope.  It finds a normal to the
       face.*/


    public static Vector4Long getNormal(PolytopeLong P) {
	int n=P.count;
	for(int i0=0;i0<n;++i0) {
	for(int i1=0;i1<n;++i1) {
	for(int i2=0;i2<n;++i2) {
	for(int i3=0;i3<n;++i3) {
        Vector4Long[] X=new Vector4Long[3];
	X[0]=Vector4Long.minus(P.V[i0],P.V[i3]);
	X[1]=Vector4Long.minus(P.V[i1],P.V[i3]);
	X[2]=Vector4Long.minus(P.V[i2],P.V[i3]);
	Vector4Long Y=Vector4Long.perp(X);
	if(Y.isZero()==false) return Y;
	}}}}
	return null;
    }





    /**This gets the list of all generalized normals which are
       perpendicular to a given vector.  This is used in
       extracting the normals to the codimension 1 faces.*/

    public static Vector4Long[] faceNormalsPM(PolytopeLong P) {
	Vector4Long U=getNormal(P);
	return normalsPM(P,U);
    }





    public static Vector4Long[] normalsPM(PolytopeLong P,Vector4Long U) {
	Vector4Long[] LIST1=normals(P,U);
	Vector4Long[] LIST2=new Vector4Long[2*LIST1.length];
	for(int i=0;i<LIST1.length;++i) {
	    LIST2[2*i+0]=new Vector4Long(LIST1[i]);
	    LIST2[2*i+1]=Vector4Long.minus(new Vector4Long(0,0,0,0),LIST1[i]);
	}
	return(LIST2);
    }


    public static Vector4Long normal(PolytopeLong P,Vector4Long U,int i,int j0,int j1) {
	   Vector4Long[] X=new Vector4Long[3];
	   X[0]=Vector4Long.minus(P.V[j0],P.V[i]);
	   X[1]=Vector4Long.minus(P.V[j1],P.V[i]);
	   X[2]=new Vector4Long(U);
	   return Vector4Long.perp(X);
    }

    /**this gets the list of all generalized normals*/
    public static Vector4Long[] normals(PolytopeLong P,Vector4Long U) {
	int n=P.count;
	int count=0;
	Vector4Long[] LIST=new Vector4Long[n*n];
	for(int i=0;i<n;++i) {
	    for(int j0=i+1;j0<n;++j0) {
	    for(int j1=j0+1;j1<n;++j1) {
		Vector4Long W=normal(P,U,i,j0,j1);
		if(W.isZero()==false) {
		    if(ListHelp.onListWide(W,LIST,count)==false) {
		      LIST[count]=new Vector4Long(W);
		      ++count;
		    }
		}
	    }}
	}
	return ListHelp.trim(LIST,count);
    }



}














