import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This program has the tests that the various polytopes are
   clean with respect to various of the partitions.*/


public class ProofClean {

    public static void main() {
       testCleanZ(0,0);
       testCleanZ(1,0);
       testCleanZ(1,1);
       testCleanZ(1,2);
       testCleanX(0);
       testCleanX(1);
       testCleanY();
    }





    /**This tests that every polytope in the given partition is Z clean.
       Parameters:  choice=0 gives plaid pieces. choice=1 gives
       clean partition pieces. power=k gives F_X^k(piece).*/

    public static void testCleanZ(int choice,int power) {
	System.out.println("checking Z-clean "+choice+" "+power);
	int lim=26;
	if(choice==1) lim=190;
	for(int i=0;i<lim;++i) {
	    PolytopeLong P=new PolytopeLong();
	    if(choice==0) P=AllPolytopesLong.plaid(i);
	    else P=AllPolytopesLong.clean(i);
	    P=DynamicsPlaid.F(power,P);
	    String S="plaid partition ";
	    if(choice>0) S="clean partition ";
	    Integer POWER=new Integer(power);
	    int test=cleanZ(P);
	    if(test==-1) throw new ProofException("clean1 fail");
	    if(Verbose.WORD==true) {
	      System.out.print(S);  
              System.out.print("power "+POWER.toString());
	      System.out.print(" piece "+i+": ");
	      if(test<2) System.out.println("Z");
	      else System.out.println("Z'");
	    }
	}
	System.out.println("done");
    }

    /**This tests that every polytope in the C partition is X clean.
       power=k gives F_X^k(piece).*/

    public static void testCleanX(int power) {
	System.out.println("checking X-clean "+power);
	for(int i=0;i<190;++i) {
	    PolytopeLong P=AllPolytopesLong.clean(i);
	    P=DynamicsPlaid.F(power,P);
	    Integer POWER=new Integer(power);
	    int test=cleanX(P);
	    if(test==-1) throw new ProofException("clean1 fail");
	    if(Verbose.WORD==true) {
              System.out.print("power "+POWER.toString());
	      System.out.println(" piece "+i+": "+test);
	    }
	}
	System.out.println("done");
    }


    /**This tests for each polytope P in the C partition that omega(C)
       is Y-clean*/

    public static void testCleanY() {
	System.out.println("checking Y-clean");
	for(int i=0;i<190;++i) {
	    PolytopeLong P=AllPolytopesLong.clean(i);
	    P=PlaidToGraph.omega(P);
	    int test=cleanY(P);
	    if(test==-1) throw new ProofException("Y clean test fails");
	    if(Verbose.WORD==true) System.out.println("image "+test);
	}
	System.out.println("done");
    }


	/**This tests if a given polytope is X clean.  This
           routine translates the X polytopes around in order
           to catch some polytope images which could be far flung.*/


	public static int cleanX(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<26;++i) {
	    PolytopeLong Q0=AllPolytopesLong.plaid(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
	    for(int k2=-lim;k2<=lim;++k2) {
		PolytopeLong Q=DynamicsPlaid.plaidShift(k0,k1,k2,Q0);
		if(Q.contains(P)) return i;
	    }}}}}
	    return -1;
	}


	public static int cleanY(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<28;++i) {
	    PolytopeLong Q0=AllPolytopesLong.graph(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
	    for(int k2=-lim;k2<=lim;++k2) {
		PolytopeLong Q=DynamicsGraph.graphShift(2*k0,k1,k2,Q0);
		if(Q.contains(P)) return i;
	    }}}}}
	    return -1;
	}

	/**This tests if a given polytope is Z clean.  This
           routine translates the Z polytopes around in order
           to catch some polytope images which could be far flung.*/

	public static int cleanZ(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<4;++i) {
	    PolytopeLong Q0=AllPolytopesLong.Zbig(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
		PolytopeLong Q=DynamicsPlaid.plaidShift(2*k0,k1,0,Q0);
		if(Q.contains(P)) return i;
	    }}}}
	    return -1;
	}





}


