import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This checks that the polyhedra in the following partitions are
   strictly convex and tight:

   plaid partition
   graph partition
   clean partition
   Z partition

   Here tight means that every vertex is an extreme point.*/

public class ProofConvex {

    public static void main() {
	testPlaid();
	testGraph();
	testTight();
	testZ();
    }



    public static void testPlaid() {
	System.out.println("test plaid polytopes are tight convex ");
	for(int i=0;i<26;++i) {
           PolytopeLong P=AllPolytopesLong.plaid(i);
	   boolean test=P.isTightConvex();
	   if(Verbose.WORD==true) System.out.println(i+" "+test);
	   if(test==false) throw new ProofException("fail");
	}
	System.out.println("done");
    }

    public static void testGraph() {
	System.out.println("test graph polytopes are tight convex ");
	for(int i=0;i<28;++i) {
           PolytopeLong P=AllPolytopesLong.graph(i);
	   boolean test=P.isTightConvex(); 
           if(Verbose.WORD==true) System.out.println(i+" "+test);
	   if(test==false) throw new ProofException("fail");
	}
	System.out.println("done");
    }

    public static void testTight() {
	System.out.println("test clean partition polys are tight convex ");
	for(int i=0;i<95;++i) {
           PolytopeLong P=AllPolytopesLong.clean(i);
	   boolean test=P.isTightConvex();  
           if(Verbose.WORD==true) System.out.println(i+" "+test);
	   if(test==false) throw new ProofException("fail");
	}
	System.out.println("done");
    }


    public static void testZ() {
	System.out.println("test Z partition polys are tight convex ");
	for(int i=0;i<4;++i) {
           PolytopeLong P=AllPolytopesLong.Zsmall(i);
	   boolean test=P.isTightConvex(); 
           if(Verbose.WORD==true) System.out.println(i+" "+test);
	   if(test==false) throw new ProofException("fail");
	}
	System.out.println("done");
    }

}


