import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This checks that the prism quotient Z is dynamically
large. All we have to do is take the pieces listed
9,10,11,12,13 and check that they are mapped into
the Z piece.  These pieces are the ones that do not
lie in Z*/

public class ProofDynLarge {

    public static void main() {
	System.out.println("test dynamically large");
	test(0);
	test(1);
    }

    public static void test(int choice) {
	System.out.println("forward direction");
	for(int i=9;i<14;++i) {
	    if(Verbose.WORD==true) System.out.println("try "+i);
	    PolytopeLong P=AllPolytopesLong.plaid(i);
	    P.code[0]=P.type[1];
	    P.code[1]=P.type[2];
	    if(choice==1) {
               P.code[0]=P.type[2];
	       P.code[1]=P.type[1];
	    }
	    PolytopeLong Q=DynamicsPlaid.F(1,P);
	    int test=insideZ(Q);
	    if(test==-1) throw new ProofException("dyn large fail");
	}
	System.out.println("done");
    }


	/**This tests if a given polytope is Z clean.  This
           routine translates the Z polytopes around in order
           to catch some polytope images which could be far flung.*/

	public static int insideZ(PolytopeLong P) {
	    for(int lim=0;lim<3;++lim) {
	    for(int i=0;i<2;++i) {
	    PolytopeLong Q0=AllPolytopesLong.Zbig(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
		PolytopeLong Q=DynamicsPlaid.plaidShift(2*k0,k1,0,Q0);
		if(Q.contains(P)) return i;
	    }}}}
	    return -1;
	}

}


