import java.awt.*;

public class ProofOrbitEquiv1 {

    public static void main() {
	System.out.println("orbit equivalence test 1");
	for(int i=0;i<190;++i) {  
	  if(Verbose.WORD==true) System.out.print("try "+i);
	  PolytopeLong P=AllPolytopesLong.clean(i); 
          int power=DataCleanPartition.whichPower(i%95);
	  if(Verbose.WORD==true) System.out.println(" map power "+power);
	  PolytopeLong Q1=map1(power,P);
	  PolytopeLong Q2=map2(P);
	  int[] test=match(Q1,Q2);
	  if(test==null) throw new ProofException("orbit equiv fail");
	}
	System.out.println("done");
    }


    public static PolytopeLong map1(int power,PolytopeLong P) {
	PolytopeLong Q=DynamicsPlaid.F(power,P);
	PolytopeLong R=PlaidToGraph.omega(Q);
	return R;
    }

    public static PolytopeLong map2(PolytopeLong P) {
	PolytopeLong Q=PlaidToGraph.omega(P);  
        int tile=whichY(Q); //see which Y tile it lands in
	int[] type=DataGraphPolytopes.type(tile);  //get dynamics code
	Q.type[1]=type[0];
	Q.type[2]=type[1];
	PolytopeLong R=DynamicsGraph.F(Q);
	return R;
    }


    public static boolean match(int[] code) {
	int[] target={2,1,3,2};
	for(int i=0;i<4;++i) {
	    if(code[i]!=target[i]) return false;
	}
	return true;
    }



    public static int[] match(PolytopeLong Q1,PolytopeLong Q2) {	
         PolytopeLong R=new PolytopeLong(Q2);
	 for(int lim=0;lim<4;++lim) {
	       for(int k0=-lim;k0<=lim;++k0) {
	       for(int k1=-lim;k1<=lim;++k1) {
	       for(int k2=-lim;k2<=lim;++k2) {
		   PolytopeLong R2=DynamicsGraph.graphShift(2*k0,k1,k2,R);
		   if(equals(R2,Q1)==true) {
		       int[] a={k0,k1,k2};
		       return a;
		   }
	       }}}}
	 return null;
    }


    public static boolean equals(PolytopeLong P,PolytopeLong Q) {
	if(P.count!=Q.count) return false;
	for(int i=0;i<P.count;++i) {
	    for(int j=0;j<4;++j) {
		if(P.V[i].x[j]!=Q.V[i].x[j]) return false;
	    }
	}
	return true;
    }


    /**This tells which Y-piece the Omega(P) lands in*/

	public static int whichY(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<28;++i) {
	    PolytopeLong Q0=AllPolytopesLong.graph(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
	    for(int k2=-lim;k2<=lim;++k2) {
		PolytopeLong Q=DynamicsGraph.graphShift(2*k0,k1,k2,Q0);
		if(Q.contains(P)) return i;
	    }}}}}
	    return -1;
	}

	public static int whichZ(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<4;++i) {
	    PolytopeLong Q0=AllPolytopesLong.Zbig(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
		PolytopeLong Q=DynamicsPlaid.plaidShift(2*k0,k1,0,Q0);
		if(Q.contains(P)) return i;
	    }}}}
	    return -1;
	}



}


