import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This contains the proof that the clean partition really is a
   partition.*/

public class ProofPartition {

    public static void main() {
	checkVolume();
	pairwiseDisjoint();
	checkContain();
    }

    /**This checks that the union of the pieces in the clean
       partition has the same volume as the volume of the
       piece Z_+^*.  This is the fundamental domain for
       the action of the lattice on the prism: The intersection
       of Z_+ with the space R^2 x [-1,1] x [0,1].*/

    public static void checkVolume() {
	System.out.println("checking volume");
	long total=0;
	for(int i=0;i<95;++i) {
	   PolytopeLong P=AllPolytopesLong.clean(i);
	   long vol=PolytopeLongVolume.volume(P);
	   if(Verbose.WORD==true) System.out.println("piece "+i+" volume "+vol);
	   total=total+vol;
	}
	PolytopeLong P=AllPolytopesLong.Zsmall(0);
        long vol=PolytopeLongVolume.volume(P);
	long v=total-vol;
	System.out.println(total+" "+vol);
	if(v!=0) throw new ProofException("volume fails");
    }

    /**This checks that the polytopes in the
       clean partition have pairwise disjoint interiors*/

    public static void pairwiseDisjoint() {
	System.out.println("start clean partition convex ");
	for(int i=0;i<95;++i) {
           PolytopeLong P=AllPolytopesLong.clean(i);
	   boolean test=P.isTightConvex();
	   if(Verbose.WORD==true) System.out.println("try "+i);
	   if(test==false) throw new ProofException("fail");
	}
	System.out.println("done");
    }

    /**This checks that every polytope of the clean partition
       lies inside the polytope Z*_+   */

    public static void checkContain() {
	System.out.println("start containment test");
	long total=0;
	PolytopeLong Q=AllPolytopesLong.Zsmall(0);
	for(int i=0;i<95;++i) {
	   PolytopeLong P=AllPolytopesLong.clean(i);
	   if(Verbose.WORD==true) System.out.println("try "+i);
	   boolean test=Q.contains(P);
	   if(test==false) throw new ProofException("containment fails");
	}
	System.out.println("done");
    }

}



