import java.awt.*;

public class ProofSquare {

    public static void main() {
	collectCodes();
    }

    public static void collectCodes() {
	System.out.println("start computing table");
    int[][][] LIST=new int[4][100][2];
    int[] COUNT=new int[4];
	for(int i=0;i<190;++i) {  
	  PolytopeLong P=AllPolytopesLong.clean(i); 
	  int[] type=getImageType(P);
	  int t=P.code[1];
	  if(ListHelp.onList(type,LIST[t],COUNT[t])==false) {
	      if(P.code[0]!=P.code[1]) {
		  LIST[t][COUNT[t]]=type;	  
                  if(Verbose.WORD==true) {
                      System.out.print(t+"---> ");
		      ListHelp.printout(LIST[t],COUNT[t]);
		  }
		++COUNT[t];
	      }
	  }
	}
	System.out.println("final tabulation");
	int[][] vec={{0,-1},{-1,0},{0,1},{1,0}};

	for(int t=0;t<4;++t) {
	    System.out.print("("+vec[t][0]+","+vec[t][1]+") --> ");
              ListHelp.printout(LIST[t],COUNT[t]);
	}
	System.out.println("done");
    }

    public static void printPlaid(int[] a) {
	if(a[0]==a[1]) {
            System.out.print(0+" "+0+" ---> ");
	    return;
	}
	if(a[1]==0) System.out.print(0+","+-1);
	if(a[1]==1) System.out.print(-1+","+0);
	if(a[1]==2) System.out.print(0+","+1);
	if(a[1]==3) System.out.print(1+","+0);
	System.out.print(" ----> ");
    }



    public static void printGraph(int[] a) {
	System.out.println(a[0]+" "+a[1]);
    }



    public static int[] getImageType(PolytopeLong P) {
	PolytopeLong Q=PlaidToGraph.omega(P);  
        int tile=whichY(Q); //see which Y tile it lands in
	int[] type=DataGraphPolytopes.type(tile);  //get dynamics code
	return type;
    }


    public static boolean match(int[] code) {
	int[] target={2,3,1,2};
	for(int i=0;i<4;++i) {
	    if(code[i]!=target[i]) return false;
	}
	return true;
    }




    public static boolean equals(PolytopeLong P,PolytopeLong Q) {
	if(P.count!=Q.count) return false;
	for(int i=0;i<P.count;++i) {
	    for(int j=0;j<4;++j) {
		if(P.V[i].x[j]!=Q.V[i].x[j]) return false;
	    }
	}
	return true;
    }


    /**This tells which Y-piece the Omega(P) lands in*/

	public static int whichY(PolytopeLong P) {
	    for(int lim=0;lim<4;++lim) {
	    for(int i=0;i<28;++i) {
	    PolytopeLong Q0=AllPolytopesLong.graph(i);
	    for(int k0=-lim;k0<=lim;++k0) {
	    for(int k1=-lim;k1<=lim;++k1) {
	    for(int k2=-lim;k2<=lim;++k2) {
		PolytopeLong Q=DynamicsGraph.graphShift(2*k0,k1,k2,Q0);
		if(Q.contains(P)) return i;
	    }}}}}
	    return -1;
	}
    }


