import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This does basic integer vector arithmetic*/


public class Vector4Long {
    long[] x=new long[4];
    long denominator; 
    public Vector4Long(){}


    public Vector4Long(long a,long b,long c,long d) {
	x[0]=a;
	x[1]=b;
	x[2]=c;
	x[3]=d;
    }

    public Vector4Long(Vector4Long xx) {
	for(int i=0;i<4;++i) x[i]=xx.x[i];
    }


    public static long dist2(Vector4Long V1,Vector4Long V2) {
	Vector4Long X=minus(V1,V2);
	long d=dot(X,X);
	return(d);
    }




    public static Vector4Long plus(Vector4Long V1,Vector4Long V2) {
	Vector4Long W=new Vector4Long();
	for(int i=0;i<4;++i) W.x[i]=V1.x[i]+V2.x[i];
	return(W);
    }


    public static Vector4Long minus(Vector4Long V1,Vector4Long V2) {
	Vector4Long W=new Vector4Long();
	for(int i=0;i<4;++i) W.x[i]=V1.x[i]-V2.x[i];
	return(W);
    }

    public Vector4Long scale(long r) {
	Vector4Long W=new Vector4Long();
	for(int i=0;i<4;++i) W.x[i]=r*x[i];
	return(W);
    }


    public static long dot(Vector4Long V1,Vector4Long V2) {
	long d=0;
	for(int i=0;i<4;++i) d=d+V1.x[i]*V2.x[i];
	return(d);
    }

    public boolean isZero() {
	long x=dot(this,this);
	if(x==0) return true;
	return false;
    }

    public void print() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]+" "+x[3]);
    }

    public void printRational() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]+" "+x[3]+"  /  "+denominator);
    }

    /**This does a 3x3 determinant*/
    public static long det(long[][] a) {
	long x=0;
        x=x+a[0][0]*a[1][1]*a[2][2];
	x=x+a[0][1]*a[1][2]*a[2][0];
	x=x+a[0][2]*a[1][0]*a[2][1];
        x=x-a[0][1]*a[1][0]*a[2][2];
	x=x-a[0][2]*a[2][0]*a[1][1];
	x=x-a[1][2]*a[2][1]*a[0][0];
	return(x);
    }

    /**takes the appropriate 3x3 minor*/
    public static long[][] toMatrix(Vector4Long[] V,int k) {
	long[][] a=new long[3][3];
	int count=0;
	for(int i=0;i<3;++i) {
	    count=0;
	    for(int j=0;j<4;++j) {
		if(j!=k) {
		    a[i][count]=V[i].x[j];
		    ++count;
		}
	    }
	}
	return(a);
    }

    /**gets a vector orthogonal to a list of 3 vectors*/
    public static Vector4Long perp(Vector4Long[] V) {
	Vector4Long W=new Vector4Long();
	for(int i=0;i<4;++i) {
	    long[][] a=toMatrix(V,i);
	    W.x[i]=det(a);
	    if(i%2==1) W.x[i]=-W.x[i];
	}
	return(W);
    }

    /**gets a random vector with coordinates in [-20,20]*/
    public static Vector4Long random() {
	Vector4Long V=new Vector4Long();
	for(int i=0;i<4;++i) {
	    V.x[i]=(long)(20-40*Math.random());
	}
	return(V);
    }

    /**This divides out by the denominator if it is possible*/


    public Vector4Long legalSimplify() {
	Vector4Long W=new Vector4Long(this);
	for(int i=0;i<4;++i) W.x[i]=legalDivide(this.x[i],this.denominator);
	return W;
    }


    public static long legalDivide(long a,long b) {
	long a0=a;
	long b0=b;
	if(a<0) a0=-a;
	if(b<0) b0=-b;
	if(a0%b0!=0) return -999999;
	return a/b;
    }



}




