import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This tile computes the polytope exchange tiles and also
   the arithmetic graph.*/

public class ComputePolytope implements Runnable {
    int halt;
    Manager M;

    public ComputePolytope() {}

    public ComputePolytope(Manager MM) {
	this.M=MM;
    }

    public void run() {	
	halt=1;
      	int[] a={0,0,0,0};
	for(int i=0;i<3;++i) a[i]=M.C.ACTION.L[i].on;
	if(a[1]==1) tilePlot(false);
	if(a[2]==1) tilePlot(true);
        graphPlot();
	halt=0;
    }


    public double getParameter() {
	return(M.C.SES1.getParameter());
    }

    /**This routine plots the entire tile,
       assuming that the orbit is within
       range. **/

    public void tilePlot(boolean TOTAL) {
	int limit=(int)(Math.pow(2,M.C.ORBIT.val));
	double a=getParameter();
	Vector INIT=getFromQTC();
	Vector INIT0=new Vector(INIT);
	Vector[] FIN=initialConstraints();

	int i=0;
	boolean test=false;
	while((i<limit)&&(test==false)) {
	  Vector[] W=getConstraints(a,INIT);
	  FIN=shrinkWrap(FIN,W);
	  INIT=Torus.map2(a,INIT);
	  if(Vector.dist(INIT,INIT0)<.000000001) test=true;
	  ++i;
	}
	int orbit=i;i=0;
	if(test==false) System.out.println("too big");
	if(test==true) {
          Parallelotope X1=Parallelotope.X1(a);
	  Parallelotope X2=Parallelotope.X2(a);
	  X1.V[0]=FIN[0];
	  X1.V[1]=FIN[1];
	  X2.V[0]=FIN[2];
	  X2.V[1]=FIN[3];
	  if(TOTAL==false) orbit=1;
          sendTile(X1,X2,orbit,INIT0);
	}
    }


    /**This routine sends the tile data to the navigator canvas*/

    public void sendTile(Parallelotope Y1,Parallelotope Y2,int orbit,Vector INIT0) {
	Vector INIT=new Vector(INIT0);	 
	double a=getParameter();

	//test if PET window is up
	try{int ping=M.N.COUNT;}
	catch(Exception e) {return;}

	for(int i=0;i<orbit;++i) {
          Parallelotope X1=Y1.translateBy(INIT);
	  Parallelotope X2=Y2.translateBy(INIT);
	  int c=M.N.COUNT;
	  M.N.X1[c]=new Parallelotope(X1);
	  M.N.X2[c]=new Parallelotope(X2);
	  M.N.COLOR[c]=M.C.CS.C;
	  ++M.N.COUNT;
	  INIT=Torus.map2(a,INIT);
	}
	M.repaint();
    }

    /**This routine gets the vector right from the
       QTC window when the PET is down.*/

	public Vector getFromQTC() {
	   double a=getParameter();
	   int[] q={1,1,0,1};
           Vector TEST=Torus.psiDomain(q,a,M.P.SOURCE);
	   return TEST;
	}

    public void graphPlot() { 
	double a=getParameter();
	int limit=(int)(Math.pow(2,M.C.ORBIT.val));
	Vector INIT=getFromQTC();

	Vector ORBIT=new Vector(INIT);
	Path2D.Double gp=new Path2D.Double();
	int i=0;
	boolean test=false;
	Vector[] Q=new Vector[limit];
	Q[0]=new Vector(0,0,0,0,0);

	while((i<limit)&&(test==false)) {
	  ++i;
	  Vector NEW=getLocation(a,ORBIT);
	  Q[i]=Vector.plus(Q[i-1],NEW);
	  ORBIT=Torus.map2(a,ORBIT);
	  if(Vector.dist(INIT,ORBIT)<.000000001) test=true;
	}

	double x=0;
	double y=0;
	int lim=i;
	for(int j=0;j<lim;++j) {
	  x=Q[j].x[2];
	  y=Q[j].x[1]+Q[j].x[2]+Q[j].x[3];
	  if(j==0) gp.moveTo(x,y);
	  if(j!=0) gp.lineTo(x,y);
	}

	if(x*x+y*y<4)	gp.closePath();


	try{
          M.G.COUNT=0;
	  M.G.TILE[M.G.COUNT]=gp;
          M.G.COLOR[M.G.COUNT]=M.C.CS.C;
          ++M.G.COUNT;
	}
	catch(Exception e) {}
        M.repaint();
    }




    /**This routine sets the initial constraints,
       so that the initial 2 parallelotopes are
       larger than the space.*/

    public Vector[] initialConstraints() {
	double[] q={1,1,1,1,1};
	Vector[] W=new Vector[4];
	for(int i=0;i<4;++i) W[i]=new Vector(q);
	W[0]=Vector.scale(-1,W[0]);
	W[2]=Vector.scale(-1,W[2]);
	return(W);
    }

    /**This routine intersects one pair of parallelopipeds with another.*/

    public Vector[] shrinkWrap(Vector[] V1,Vector[] V2) {
	Vector[] W=new Vector[4];
	W[0]=Vector.max(V1[0],V2[0]);
	W[1]=Vector.min(V1[1],V2[1]);
	W[2]=Vector.max(V1[2],V2[2]);
	W[3]=Vector.min(V1[3],V2[3]);
	return(W);
    }

    /**This is the main routine.  It does one iterate of the
       map and computes how close the point gets to the walls
       of the partition defining the PET.*/

    public Vector[] getConstraints(double a,Vector INIT) {
	Matrix m=Torus.L(a);
	Vector[] V=new Vector[4];
	V[0]=Matrix.act(m,INIT);
	V[1]=Torus.toDomain1(a,V[0]);
	V[2]=Vector.minus(V[0],V[1]);
	V[3]=Matrix.act(m,V[2]);
	Parallelotope X1=Parallelotope.X1(a);
	Parallelotope X2=Parallelotope.X2(a);
	X1=X1.translateBy(Vector.scale(-1,INIT));
	X2=X2.translateBy(Vector.minus(V[3],INIT));
	Vector[] W={X1.V[0],X1.V[1],X2.V[0],X2.V[1]};
	return(W);
    }

    /**This finds the integer vector V such that 
       INIT + L(V) lies in the parallelotope X2.**/

    public static Vector getLocation(double a,Vector INIT) {
	Matrix m=Torus.L(a);
	Vector[] V=new Vector[4];
	V[0]=Matrix.act(m,INIT);
	V[1]=Torus.toDomain1(a,V[0]);
	V[2]=Vector.minus(V[0],V[1]);
	return(V[2]);
    }

    /**This is the same routine as the previous one, except
       that it returns an integer list rather than a vector*/

    public static int[] getLocationInt(double a,Vector INIT) {
	Matrix m=Torus.L(a);
	Vector[] V=new Vector[4];
	V[0]=Matrix.act(m,INIT);
	V[1]=Torus.toDomain1(a,V[0]);
	V[2]=Vector.minus(V[0],V[1]);
	for(int i=0;i<4;++i) V[2].x[i]=Math.floor(.5+V[2].x[i]);
	int[] Q=new int[4];
	for(int i=0;i<4;++i) Q[i]=(int)(V[2].x[i]);
	return(Q);
    }

}









