import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ComputeTile implements Runnable {
    int halt;
    Manager M;
    double a0,a1;
    int[] q={1,1,0,1};
    double denX,denY,range;
    int ORBIT;
    public ComputeTile() {}

    public ComputeTile(Manager MM) {
	this.M=MM;
    }

    public void run() {	
	halt=1;
        a0=M.C.SES1.getParameter();
	a1=a0;
        int limit=(int)(Math.pow(2,M.C.ORBIT.val));
	int[] a={0,0,0,0,0};
	for(int i=0;i<3;++i) a[i]=M.C.ACTION.L[i].on;
	if(a[1]==1) tilePlot();
	if(a[2]==1) tileOrbitPlot(limit);
	M.P.repaint();
	halt=0;
    }

    /**This Computes The Orbit*/

    public double[][] getTileConstants(int limit,boolean PARTIAL) {
	boolean test=false;
	Complex z0=new Complex(M.P.SOURCE);
	Complex z1=new Complex(z0);
	int count=0;
	double[][] A0=new double[4][4];
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		A0[i][j]=999999;
	    }
	}
	double[][] A=new double[4][4];
	while((test==false)&&(count<limit)) {
	    A=QTCKite.mapPosition(q,a0,a1,z1);
	    A0=QTCGeneral.minimize(A,A0,4);
	    z1=QTCKite.map(q,a0,a1,z1);
	    if(Complex.dist(z1,z0)<.0000001) test=true;
	    ++count;
	}
	if((PARTIAL==false)||(test==true)) {
	    ORBIT=count;
            return(A0);
	}
	ORBIT=0;
	return(null);
    }

    public void sentOrbitData() {
	if(ORBIT==0) M.P.MESSAGE="orbit too big";
	else {
	    Integer X=new Integer(ORBIT);
	    M.P.MESSAGE="orbit "+X.toString();
	}
    }

    public void tilePlot() {
	int limit=(int)(Math.pow(2,M.C.ORBIT.val));
	double[][] A=getTileConstants(limit,true);

	if(A!=null) {
          Path2D.Double gp=CreateTile.tile(a0,a1,A,M.P.SOURCE);
	  M.P.TILE[M.P.COUNT]=new Path2D.Double(gp);
	  M.P.COLOR[M.P.COUNT]=M.C.CS.C;   
          M.P.TYPE[M.P.COUNT][0]=0;
	  ++M.P.COUNT;
	  sentOrbitData();
	}
    }

    public void tilePlot(int limit) {
	double[][] A=getTileConstants(limit,false);
	double a= M.C.SES1.getParameter();
	Vector W=Torus.psiDomain(q,a,M.P.SOURCE);
	int[] Q=ComputePolytope.getLocationInt(a,W);
	int[] move={Q[1]+Q[2]+Q[3],Q[2]};


	if(A!=null) {
          Path2D.Double gp=CreateTile.tile(a0,a1,A,M.P.SOURCE);
	  M.P.TILE[M.P.COUNT]=new Path2D.Double(gp);
	  M.P.COLOR[M.P.COUNT]=Color.green;
          if(limit==1) {
             M.P.TYPE[M.P.COUNT][0]=1;
             M.P.TYPE[M.P.COUNT][1]=move[0];
             M.P.TYPE[M.P.COUNT][2]=move[1];
	  }
          if(limit>1) M.P.TYPE[M.P.COUNT][0]=0;
	  ++M.P.COUNT;
	}
    }



    public void tileOrbitPlot(int cutoff) {
	int limit=(int)(Math.pow(2,M.C.ORBIT.val));
	double[][] A=getTileConstants(limit,true);
	if(A!=null) {
	  Complex z0=new Complex(M.P.SOURCE);
	  Complex z1=new Complex(z0);
	  int count=0;
	  boolean test=false;
	  while((test==false)&&(count<limit)) {
	      if(count<cutoff) {
                Path2D.Double gp=CreateTile.tile(a0,a1,A,z1);
	        M.P.TILE[M.P.COUNT]=new Path2D.Double(gp);
	        M.P.COLOR[M.P.COUNT]=M.C.CS.C;
	        M.P.TYPE[M.P.COUNT][0]=0;
	        ++M.P.COUNT;
	      }
            z1=QTCKite.map(q,a0,a1,z1);
	    if(Complex.dist(z1,z0)<.0000001) test=true;
	    ++count;
	  }
	}
    }


}









