import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements KeyListener,MouseListener,MouseMotionListener {
    Manager M;
    SelectColor CS;
    ShapeEntryBasic SES1;
    SelectInteger ORBIT,POINT;
    ControlPanel ACTION,RESET,BINARY,COLOR,KITE,TILE,FIT,DIRECTION;
    ControlPanelColor PET,TILES,COLOR1,COLOR2,COLOR3;
    String MESSAGE;
    ListenSquare[] RENORM=new ListenSquare[3];
    PopupManager POP;


     public ControlCanvas() {
	 addKeyListener(this);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 makeControls();
	 setControlPanels();
     }

    public void makeControls() {
         CS=new SelectColor(M,5,160,450,50);
	 SES1=new ShapeEntryBasic(305,70);
	 POP=new PopupManager(this.M,305,5);
	 ORBIT=new SelectInteger(305,135,40,20,12,1,20,1);
    }


    public void setControlPanels() {	 
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};

	 String[] ActionString={"none","tile","orbit","QTC action"};
	 int[] ActionState={0,0,1};
         ACTION=new ControlPanel(C0,ActionString,ActionState,3);

	 String[] KiteString={"all","\u0394","range"};
	 int[] KiteState={0,1,0};
         KITE=new ControlPanel(C0,KiteString,KiteState,2);
	 KITE.mode=1;

	 String[] DirectionString={"forward","backward","partition"};
	 int[] DirectionState={1,0};
         DIRECTION=new ControlPanel(C0,DirectionString,DirectionState,2);
	 DIRECTION.mode=0;

	 String[] TileString={"small","medium","large","tile extent"};
	 int[] TileState={0,1,0};
         TILE=new ControlPanel(C0,TileString,TileState,3);
	 TILE.mode=1;

	 String[] ResetString={"QTC","graph","PET","all","reset"};
	 int[] ResetState={0,0,0,0};
         RESET=new ControlPanel(C0,ResetString,ResetState,4);

	 String[] ColorString={"QTC","graph","PET","color"};
	 int[] ColorState={1,0,0};
         COLOR=new ControlPanel(C0,ColorString,ColorState,3);

	 String[] Color1String={"bg","strip","\u0394","cursor","QTC"};
	 Color[] Color1Color={new Color(0,0,100),new Color(0,0,0),new Color(255,255,0),new Color(100,100,100,100)};
	 int[] Color1State={1,1,1,1};
         COLOR1=new ControlPanelColor(C0,Color1String,Color1State,4,Color1Color);


	 String[] Color2String={"bg","grid","cursor","graph","graph"};
	 Color[] Color2Color={Color.black, new Color(0,0,150),Color.orange,Color.white};
	 int[] Color2State={1,1,1,1};
         COLOR2=new ControlPanelColor(C0,Color2String,Color2State,4,Color2Color);


	 String[] Color3String={"bg","axes","colors","PET"};
	 Color[] Color3Color={new Color(0,0,100), new Color(100,100,100),new Color(0,0,0)};
	 int[] Color3State={1,0,1};
         COLOR3=new ControlPanelColor(C0,Color3String,Color3State,3,Color3Color);

	 String[] S1={"yes","no","autofit"};
	 int[] state1={1,0};
         FIT=new ControlPanel(C0,S1,state1,2);
	 FIT.mode=0;
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(new Color(0,00,180));
      g.fillRect(0,0,getWidth(),getHeight()); 
      drawControls(g);
   }



    public void drawControls(Graphics2D g) { 
      CS.render(g);
      SES1.render(g);
      orbitControlDraw(g);
      g.setColor(Color.white);
      COLOR.render(g,80,5,70);
      if(COLOR.mode==0) COLOR1.render(g,80,75,70);
      if(COLOR.mode==1) COLOR2.render(g,80,75,70);
      if(COLOR.mode==2) COLOR3.render(g,80,75,70);
      RESET.render(g,5,75,70);   
      ACTION.render(g,5,5,70);   
      KITE.render(g,155,5,70);    
      TILE.render(g,155,60,70);
      FIT.render(g,230,5,70); 
      DIRECTION.render(g,230,60,70); 
      POP.render(g);
    }


    public void orbitControlDraw(Graphics2D g) {
      ORBIT.render2(g,Color.red,Color.white,Color.white,"orbit limit");
    }

    public int[] getBinary() {
	int[] q={1,1,0,1,0};
	return q;
    }


    public void orbitControls(Point X) {
	ORBIT.modify(X);
    }

    public void doAction() {
	M.P.regionPlot(false);
    }

    public void doReset(Point X) {

	int val=RESET.getValue(X);
	if(val==20) documentStuff(3);

	if(val==0) {
	  M.P.COUNT=0;
	}
	if(val==1) {
	    try{M.G.COUNT=0;}
	    catch(Exception e) {}
	}
	if(val==2) {
            try{ M.N.COUNT=0;}
	    catch(Exception e) {}
	}

	if(val==3) {
	  M.P.COUNT=0; 
          try{M.G.COUNT=0;}
	  catch(Exception e) {}
          try{M.N.COUNT=0;}
	  catch(Exception e) {}
	}
    }


    public void setView() {
	try{M.S.SLICE.forceKiteNeutral(M);}
	catch(Exception e) {}
    }

    public void documentStuff(int choice) {
	try{
	    if(choice==1) DocumentControl.action(M.D);
	    if(choice==2) DocumentControl.kite(M.D);
	    if(choice==3) DocumentControl.reset(M.D);
	    if(choice==4) DocumentControl.color(M.D);
	    if(choice==5) DocumentControl.color2(M.D);
	    if(choice==6) DocumentControl.tile(M.D);
	    if(choice==7) DocumentControl.fit(M.D);
	    if(choice==8) DocumentControl.dir(M.D);
	}
	catch(Exception e) {}
    }

    public void mouseClicked(MouseEvent e) {
      
	POP.M=this.M;
        MouseData J=MouseData.process(e);
	orbitControls(J.X);
	doReset(J.X);
	SES1.processMouse(e);
	int doc=ACTION.switchMode(J.X);
	if(doc==20) documentStuff(1);

	doc=KITE.switchMode(J.X);
	if(doc==20) documentStuff(2);

	doc=TILE.switchMode(J.X);
	if(doc==20) documentStuff(6);

	doc=FIT.switchMode(J.X);
	if(doc==20) documentStuff(7);

	doc=DIRECTION.switchMode(J.X);
	if(doc==20) documentStuff(8);

	doc=COLOR.switchMode(J.X);
	if(doc==20) documentStuff(4);

	if(COLOR.mode==0) doc=COLOR1.process(J.X,CS.C);
	if(COLOR.mode==1) doc=COLOR2.process(J.X,CS.C);
	if(COLOR.mode==2) doc=COLOR3.process(J.X,CS.C);

	if(doc==20) documentStuff(5);
        CS.process(e); 
	POP.process(J.X);
	repaint();
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
	 repaint();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) {
        SES1.processKey(e);
	repaint();
    }

    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


    public void doTest() {
    }




}

