import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


/**This class takes the convex hull of a finite set of
   points in the plane**/

public class ConvexHull {

    /**Here is the main routine**/

    public static PolygonWrapper convexHull(PolygonWrapper PP) {
	if(PP==null) return(null);
	if(PP.count==0) return(null);
	PolygonWrapper P=weedOut(PP);
	if(P.count==1) return(null);
	PolygonWrapper Q=new PolygonWrapper();
	int[] n=new int[100];
        int match;
        int ct;
	for(int i=0;i<P.count;++i) Q.z[i]=new Complex(P.z[i]);
	Q.count=P.count;
        n[0]=bottom(Q);
        match=0;
        ct=0;
	Complex z1=P.z[0];

        while(match==0) {
           n[ct+1]=nextPoint(Q,n[ct]);
	   Complex z0=P.z[n[ct+1]];
           if(n[ct+1]==n[0]) match=1;
           if(ct>=P.count) match=1;
           if(n[ct+1]==-1) match=1;
           Q=roll(Q,n[ct],n[ct+1]); 
           ++ct;
	}
	for(int i=0;i<ct;++i) 	Q.z[i]=P.z[n[i]];
	Q.count=ct;
	return(Q);
    }




    /**Some supporting routines*/

    /**This weeds out redundant points, up to a small tolerance**/

    public static PolygonWrapper weedOut(PolygonWrapper P) {
	PolygonWrapper Q=new PolygonWrapper();
	int count=0;
	Q.z[1]=new Complex(P.z[0]);
	for(int i=0;i<P.count;++i) {
	    Complex w=new Complex(P.z[i]);
	    boolean redundant=false;
	    for(int j=0;j<count;++j) {
		if(Complex.dist(w,Q.z[j])<.00000000001) redundant=true;
	    }
	    if(redundant==false) {
		Q.z[count]=new Complex(w);
		++count;
	    }
	}
	Q.count=count;
	return(Q);
    }

    /*given a polygon with a horizontal edge,
      this routine finds the point immediately
      counterclockwise from the edge*/


    public static int nextPoint(PolygonWrapper P,int n) {
      double test,min;
      Complex ONE=new Complex(1,0);
      Complex w=new Complex();
      int index=-1;
      min=10000000;
      for(int i=0;i<P.count;++i) {
         if(i!=n) {
           w=Complex.minus(P.z[i],P.z[n]);
	   if(w.norm()>.0000000001) {
             w=Complex.unit(w);
             test=Complex.dist(w,ONE);
             if(test<min) {
               min=test;
               index=i;
	     }
	   }
	 }
      }
      return(index);
    }


    /*this routine rotates a polygon so that
      the edge determined by the indices a and b
      is horizontal*/


     public static PolygonWrapper roll(PolygonWrapper P,int a,int b) {
        Complex w=new Complex();
        PolygonWrapper Q=new PolygonWrapper();
        w=Complex.minus(P.z[b],P.z[a]);
        w=Complex.unit(w);
        for(int i=0;i<P.count;++i) {
           Q.z[i]=Complex.divide(P.z[i],w);
	}
        Q.count=P.count;
        return(Q);
     }


    /**Finds the bottom most point of the polygon**/

     public static int bottom(PolygonWrapper P) {
       double test,min;
       int X=-1;
       min=10000.0;
       for(int i=0;i<P.count;++i) {
         test=P.z[i].y;
         if(test<min) {
            X=i;
	    min=test;;
	 }
       }
       return(X);
     }

}