import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


/**This xlass intersects two convex polygons.  It is assumed
   that the polygons are counterclockwise oriented.*/

public class ConvexIntersect {

    public static PolygonWrapper intersect(PolygonWrapper P1,PolygonWrapper P2) {
	if(P1==null) return(null);
	if(P2==null) return(null);
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=0;
	for(int i=0;i<P1.count;++i) {
	    for(int j=0;j<P2.count;++j) {
		int i1=i;
		int i2=(i+1)%P1.count;
		int j1=j;
		int j2=(j+1)%P2.count;
		Complex q=intersect(P1.z[i1],P1.z[i2],P2.z[j1],P2.z[j2]);
		if(q!=null) {
		    if(badNumber(q)==false) {
		    Q.z[Q.count]=new Complex(q);
		    ++Q.count;
		    }
		}
	    }
	}

	for(int i=0;i<P1.count;++i) {
	    if(contains(P2,P1.z[i])==true) { 
               Q.z[Q.count]=new Complex(P1.z[i]);
	       ++Q.count;
	    }
	}

	for(int i=0;i<P2.count;++i) {
	    if(contains(P1,P2.z[i])==true) { 
               Q.z[Q.count]=new Complex(P2.z[i]);
	       ++Q.count;
	    }
	}

	try{Q=ConvexHull.convexHull(Q);}
	catch(Exception e) {return(null);}
	return(Q);
    }


    public static boolean badNumber(Complex q) {
	if(badNumber(q.x)==true) return(true);
	if(badNumber(q.y)==true) return(true);
	return(false);
    }


    public static boolean badNumber(double d) {
	double D=Double.valueOf(d);
	if(Double.isNaN(D)==true) return(true);
	if(Double.isInfinite(D)==true) return(true);
	return(false);
    }

    public static boolean contains(PolygonWrapper P,Complex z) {
	for(int i=0;i<P.count;++i) {
	    int i1=i;
	    int i2=(i+1)%P.count;
	    Complex w1=P.z[i1];
	    Complex w2=P.z[i2];
	    if(Complex.dist(z,w1)<.0000000001) return(true);
	    boolean test=Complex.isPositivelyOriented(z,w1,w2);
	    if(test==false) return(false);
	}
	return(true);
    }


    public static boolean checkSegment(Complex z1,Complex w1,Complex w2) {
	double d1=Complex.dist(z1,w1);
	double d2=Complex.dist(z1,w2);
	double d3=Complex.dist(w1,w2);
	double test=Math.abs(d1+d2-d3);
	if(test<.0000000001) return(true);
	return(false);
    }


    public static Complex intersect(Complex z1,Complex z2,Complex w1,Complex w2) {
	if(checkSegment(z1,w1,w2)==true) return(z1);
	if(checkSegment(z2,w1,w2)==true) return(z2);
	if(checkSegment(w1,z1,z2)==true) return(w1);
	if(checkSegment(w2,z1,z2)==true) return(w2);
	Complex q=intersectRaw(z1,z2,w1,w2);
	double d1=Math.max(Complex.dist(q,z1),Complex.dist(q,z2));
	double d2=Complex.dist(z1,z2);
	if(d1>d2) return(null);
        d1=Math.max(Complex.dist(q,w1),Complex.dist(q,w2));
	d2=Complex.dist(w1,w2);
	if(d1>d2) return(null);
	return(q);
    }

    public static Complex intersectRaw(Complex z1,Complex z2,Complex w1,Complex w2) {
	Vector[] V=new Vector[7];
	V[0]=new Vector(z1);
	V[1]=new Vector(z2);
	V[2]=new Vector(w1);
	V[3]=new Vector(w2);
	V[4]=Vector.cross(V[0],V[1]);
	V[5]=Vector.cross(V[2],V[3]);
	V[6]=Vector.cross(V[4],V[5]);
	Complex w=new Complex(V[6].x[0]/V[6].x[2],V[6].x[1]/V[6].x[2]);
	return(w);
    }

}