import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class CreateTile {

    /**This lists out the 8 basic linear functionals**/

    public static double[] functional(double a,int k) {
	return(functional(a,a,k));
    }

    public static double[] functional(double a1,double a2,int k) {
	double[] D={0,0};
	double b=(1+a1)/(1-a1);
	double c=(1+a2)/(1-a2);
	double d=b*b/(c*c-1);

	if(k==0) {D[0]=1;D[1]=0;}
	if(k==1) {D[0]=0;D[1]=1;}

	if(k==2) {D[0]=c;D[1]=1;}
	if(k==3) {D[0]=-1;D[1]=0;}

	if(k==4) {D[0]=d/b;D[1]=c*d/b;}
	if(k==5) {D[0]=-c/b;D[1]=-1/b;};

	if(k==6) {D[0]=0;D[1]=b;}
	if(k==7) {D[0]=-1/b;D[1]=-c/b;}
	return(D);
    }

    /**This finds the intersection of the two lines
       a0 x + a1 y - a2=0 and b0 x + b1 + b2 =0**/

     public static Complex getIntersect(double[] a,double[] b) {
	 double d=a[0]*b[1]-a[1]*b[0];
	 if(d==0) return(null);
	 double x=(a[1]*b[2]-a[2]*b[1])/d;
	 double y=(a[2]*b[0]-a[0]*b[2])/d;
	 return(new Complex(x,y));
     }

    public static double[][] lineSet(double a1,double a2,double[][] A) {
	double[][] B=new double[8][2];
	for(int i=0;i<8;++i) {
	    B[i]=functional(a1,a2,i);
	}

	double[][] C=new double[16][3];
	C[0][0]=B[0][0];C[0][1]=B[0][1];C[0][2]=-A[0][0];
	C[1][0]=B[1][0];C[1][1]=B[1][1];C[1][2]=+A[0][1];
	C[2][0]=B[0][0];C[2][1]=B[0][1];C[2][2]=+A[0][2];
	C[3][0]=B[1][0];C[3][1]=B[1][1];C[3][2]=-A[0][3];

	C[4][0]=B[2][0];C[4][1]=B[2][1];C[4][2]=-A[1][0];
	C[5][0]=B[3][0];C[5][1]=B[3][1];C[5][2]=+A[1][1];
	C[6][0]=B[2][0];C[6][1]=B[2][1];C[6][2]=+A[1][2];
	C[7][0]=B[3][0];C[7][1]=B[3][1];C[7][2]=-A[1][3];

	 C[8][0]=B[4][0]; C[8][1]=B[4][1]; C[8][2]=-A[2][0];
	 C[9][0]=B[5][0]; C[9][1]=B[5][1]; C[9][2]=+A[2][1];
	C[10][0]=B[4][0];C[10][1]=B[4][1];C[10][2]=+A[2][2];
	C[11][0]=B[5][0];C[11][1]=B[5][1];C[11][2]=-A[2][3];

	C[12][0]=B[6][0];C[12][1]=B[6][1];C[12][2]=-A[3][0];
	C[13][0]=B[7][0];C[13][1]=B[7][1];C[13][2]=+A[3][1];
	C[14][0]=B[6][0];C[14][1]=B[6][1];C[14][2]=+A[3][2];
	C[15][0]=B[7][0];C[15][1]=B[7][1];C[15][2]=-A[3][3];

	return(C);
    }

    public static Path2D.Double tile(double a,double[][] A,Complex z) {
	return(tile(a,a,A,z));
    }


    public static Path2D.Double tile(double a1,double a2,double[][] A,Complex z) {
	Complex[] LIST=pointSetRaw(a1,a2,A);
	for(int i=0;i<LIST.length;++i) LIST[i]=Complex.plus(z,LIST[i]);
	PolygonWrapper P=new PolygonWrapper(LIST.length,LIST);
	P=ConvexHull.convexHull(P);
	Path2D.Double gp=P.toPath();
	return(gp);
    }



    public static Complex[] pointSetRaw(double a1,double a2,double[][] A) {
	double[][] B=new double[8][2];
	for(int i=0;i<8;++i) B[i]=functional(a1,a2,i);
	double[][] C=lineSet(a1,a2,A);
	Complex[] LIST=new Complex[96];
	int count=0;
	for(int i=0;i<16;++i) {
	    for(int j=i+1;j<16;++j) {
		Complex z=getIntersect(C[i],C[j]);
		if(z!=null) {
		    if(isEssential(A,B,z)==true) {
		      LIST[count]=new Complex(z);
		      ++count;
		    }
		}
	    }
	}
	Complex[] LIST2=new Complex[count];
	for(int i=0;i<count;++i) LIST2[i]=new Complex(LIST[i]);
	return(LIST2);
    }



    public static boolean isEssential(double[][] A,double[][] B,Complex z) {
	double tol=.000001;
	double d1,d2;
	for(int q=0;q<3;++q) {
	  d1=B[2*q+0][0]*z.x+B[2*q+0][1]*z.y;
	  if(+d1>A[q][0]+tol) return(false);
	  if(-d1>A[q][2]+tol) return(false);
	  d2=B[2*q+1][0]*z.x+B[2*q+1][1]*z.y;  
	  if(-d2>A[q][1]+tol) return(false);
	  if(+d2>A[q][3]+tol) return(false);
	}
	return(true);
    }

}

