import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class DocumentControl {

    public static void action(DocumentCanvas D) {
	String S="QTC Action\n\n";
	S=S+"This control panel determines the action of the middle mouse button (or key-x) on the QTC window.  Nothing happens when the option is set to none.  When the option is set to `tile', the periodic tile containing the clicked point is plotted. When the option is set to 'orbit', the whole orbit is plotted.";

	S=S+"\n\nThe reason you might want to set the option to 'none' is that you might want to drag the mouse over the window and see how the point moves around in the PET compactification.  You can drag the mouse with the action set to one of the other options, but it might overload the program if you do it too long.";

     setDoc(D,S);
    }

    public static void kite(DocumentCanvas D) {
	String S="range\n\n";
	S=S+"This control panel determines the range of points you can click in the QTC window.  When the option is set to 'all' you can click any point. When the option is set to 'special', you can just click on the subset which corresponds to the special orbits.  This is the set \u0394 from Part 3 of the plaid monograph.";

     setDoc(D,S);
    }

    public static void dir(DocumentCanvas D) {
	String S="direction\n\n";
	S=S+"This control panel determines whether the program plots the forward partition associated to the PET or the backward partition.  The program does a better job drawing the forward partition.";

     setDoc(D,S);
    }

    public static void fit(DocumentCanvas D) {
	String S="autofit\n\n";
	S=S+"This control panel determines whether the arithmetic graph components are rescaled to fill the plotting window.  The components are plotted one component at a time and translated so that the origin corresponds to the selected point on the QTC window.";

     setDoc(D,S);
    }

    public static void reset(DocumentCanvas D) {
	String S="reset\n\n";
	S=S+"This control panel resets the plotted objects in each of the windows.";
     setDoc(D,S);
    }

    public static void color(DocumentCanvas D) {
	String S="color control\n\n";
	S=S+"Each of the 3 main plotting windows has several features that can be turned off and on or recolored.  This control panel brings up auxiliary controls which deal with these features. Thus, for example, if you set this control panel to QTC, you will be able to recolor and/or hide some of the objects in the QTC window.";
     setDoc(D,S);
    }


    public static void color2(DocumentCanvas D) {
	String S="auxiliary color control\n\n";
	S=S+"This is an auxiliary control panel which lets you recolor and/or hide some features of one of the 3 main plotting windows.  Each window has 2 rows of buttons. The left buttons (usually) determine the color of the feature and the right buttons show/hide the feature.  You recolor a recolorable feature by choosing a color from the color selector and then clicking the button. You should just try pushing all the buttons to see what controls what.";
     setDoc(D,S);
    }



    public static void tile(DocumentCanvas D) {
	String S="tiling extent control\n\n";

	S=S+"Let \u03A9 be the forward PET partition in the torus. Let \u03A0 be the 2-plane determined by the navigator.  This feature has 3 options for plotting the intersection of \u03A9 and [\u03A0].  Here [\u03A0] is the projection of \u03A0 to the torus.";

	S=S+"\n\n--small: This shows plots the intersection of \u03A0 with the lift of \u03A9 to the parallelotope X1 associated with the PET.";

	S=S+"\n\n--medium: This plot is designed to show exactly one fundamental domain of the periodic tiling associated to the X-slice match option on the PET slicer. In the forward case, this shows plots the intersection of \u03A0 with the lift of \u03A9 to three translates of the parallelotope X1 associated with the PET. The three translates are X1+(0,0,0,a,0) for a=-1,0,1.  In the backwards case, this shows the same thing with respect to the 6 translates X1+(i,j,0,0,0) with i,j=-1,0,1.  To get this to work perfectly, you should click on the magents slicer in the PET slicer window.";

	S=S+"\n\n--large: This shows plots the intersection of \u03A0 with the lift of \u03A9 to a bunch of translates of the parallelotope X1 associated with the PET. The exact list of translates depends on whether we are considering the forward or the backward partition.  In the backward case, I needed to use a larger list, and this makes the plotting a bit slow.";

     setDoc(D,S);
    }

    public static void navigator(DocumentCanvas D) {
	String S="PET slicer\n\n";
	S=S+"This window allows you to take various slices of the PET.";

	S=S+"\n\nIn general, the sliders on this window control determine what you are seeing in the PET window. You move them with the mouse.  Any mouse button will work. You first click to activate the slider, then you drag.";

	S=S+"\n\nThe green sliders control the direction of the slice.  The left set of 5 sliders controls the coordinates of a vector L.  The right set of 5 sliders controls the coordinates of a vector R.  The vectors L and R span the plan which comprises the slice.  More precisely. we get a planar picture by intersecting the PET with span(L,R) and mapping this into the plane so that L and R respectively are mapped to (1,0) and (0,1).";

	S=S+"\n\nThere are 3 special preset choices for these vectors:\n\n--kite: This is the slice that is parallel to the foliation given by the map from the strip into the PET.  In this slice, each tile you plot will appear the same in the PET window.  This is a good slice to use if you want to convince yourself that the PET is really a compactification of the QTC defined in the strip.\n\n--rectangle: This slice is such that all the pieces in the partition have rectangular cross section. I'm not sure what this means but it is nice to know.\n\nX slice match: This slice matches the X slice of the graph PET on the main computer program. This is the slice you want to use in order to see that the PET here is equivalent to the one on the main computer program.";

	S=S+"\n\nThe purple sliders control the position of the current point in the PET.  When the position comes from the QTC window, and you have set the range to \u0394, there will be certain restrictions on the point in the PET. However, with the purple sliders you can move anywhere.";

	S=S+"\n\nThe magenta slider moves you in a particular direction that stays inside the subset of the PET corresponding to the special orbits.  This direction corresponds to the X direction in the graph PET slicer on the main program.";

     setDoc(D,S);
    }






    public static void setDoc(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }




}

