import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class GraphCanvas extends ScaleCanvas implements KeyListener, MouseListener, MouseMotionListener {
    Manager M; 
    Path2D.Double[] TILE=new Path2D.Double[10];
    Color[] COLOR=new Color[10];
    int COUNT=0;
    ListenSquare CONTROL;
    Point KEY;

     public GraphCanvas() {
	 addKeyListener(this);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,200,20);	
         CONTROL=new ListenSquare(0,0,50,60,null); CONTROL.on=1;
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      if(M.C.FIT.mode==0) {
         try {autoFit();}
	 catch(Exception e) {}
      }
      drawBG(g);
      drawGraphs(g);  
      displaySource(g);
      if(M.C.COLOR2.L[2].on==1) drawCursor(g);

   }

    public void drawCursor(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	float a=(float)(-.5);
	float b=(float)(.5);
	gp.moveTo(a,a);
	gp.lineTo(a,b);
	gp.lineTo(b,b);
	gp.lineTo(b,a);
	gp.closePath();
	  AffineTransform A=AffineTransform.getTranslateInstance(SOURCE.x,SOURCE.y);
	  gp.transform(A);
	  gp=transform(gp);
          g.setColor(M.C.COLOR2.M[2].C);
	  g.draw(gp);
    }

    public void displaySource(Graphics2D g) {
	drawSource(g);
	GraphicsHelper.cleanDouble(g,SOURCE.x,210,13);
	GraphicsHelper.cleanDouble(g,SOURCE.y,210,26);
    }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.COLOR2.M[0].C);
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(Color.white);
	g.drawRect(0,0,getWidth()-1,getHeight()-5);
	Path2D.Double gp=new Path2D.Double();
	for(int j=-100;j<101;++j) {
	  gp.moveTo(-100,j);
	  gp.lineTo(100,j);
	  gp.moveTo(j,-100);
	  gp.lineTo(j,100);
	}
	gp=transform(gp);
	g.setColor(M.C.COLOR2.M[1].C);
	g.draw(gp);
    }

    public void drawGraphs(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	g.setStroke(new BasicStroke(2));
	for(int i=0;i<COUNT;++i) {
	    gp=new Path2D.Double(TILE[i]);
	    gp=transform(gp);
	    g.setColor(M.C.COLOR2.M[3].C);
	    g.draw(gp);
	}
 	g.setStroke(new BasicStroke(1));
    }


    /**gets the bounding box of the last graph drawn**/

    public void autoFit() {
	 Path2D.Double gp=new Path2D.Double(TILE[COUNT-1]);
	 Rectangle2D R=gp.getBounds2D();
	 Rectangle2D.Double RR=(Rectangle.Double)(R);

	 int hh=getHeight();
	 int ww=getWidth();

	 double x1=(ww-2)/RR.getWidth();
	 double x2=(hh-60)/RR.getHeight();
	 double sc=x1;
	 if(sc>x2) sc=x2;

	 double cenx=RR.x+RR.getWidth()/2;
	 double ceny=RR.y+RR.getHeight()/2;

	 A[0]=AffineTransform.getTranslateInstance(-cenx*sc+.5*ww,ceny*sc+.5*hh+25);
	 A[1]=AffineTransform.getScaleInstance(sc,-sc);
    }


    public void mousePressed(MouseEvent e) { }


    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	    if(CONTROL.inside(J.X)==0) {
            if(J.mode==1)  scaleUp(J.X,0);
            if(J.mode==3)  scaleUp(J.X,1);
	    if(J.mode==2)  {
               SOURCE=unTransform(J.X);
	       SOURCE.x=Math.floor(SOURCE.x+.5);
	       SOURCE.y=Math.floor(SOURCE.y+.5);
	    }

	}
	if(CONTROL.inside(J.X)==1) {
	    M.C.FIT.switchMode(J.X);
	}
	repaint();
    }

    public void doMouseClick(int mode) {
	if(CONTROL.inside(KEY)==1) return;
        if(mode==1)  scaleUp(KEY,0);
        if(mode==3)  scaleUp(KEY,1);
	if(mode==2)  {
           SOURCE=unTransform(KEY);
	   SOURCE.x=Math.floor(SOURCE.x+.5);
	   SOURCE.y=Math.floor(SOURCE.y+.5);
	}
	repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	KEY=J.X;
     } 
     public void mouseDragged(MouseEvent e) {
     }

    public void keyTyped(KeyEvent e) {
	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }


    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }
}

