import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

public class HSlider {
    int x,y,w,h;
    double pos;
    Color[] C;
    String S;
    boolean ON;


    public HSlider(int x,int y,int w,int h,double pos,Color[] C,String S) {
	this.x=x;
	this.y=y;
	this.h=h;
	this.w=w;
	this.pos=pos;
	this.C=C;
	this.S=S; 
	ON=false;
    }

    public void render(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	g.setColor(C[0]);
	g.fillRect(x,y,w,h);
	g.setColor(C[1]);
	if(ON==true) g.setColor(C[2]);
        g.drawRect(x,y,w,h);
	g.setColor(C[3]);
	gp.moveTo(pos,y+1);
	gp.lineTo(pos,y+h-1);
	g.setStroke(new BasicStroke(2));
	g.fill(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
        g.setFont(new Font("TimesRoman",Font.PLAIN,15));
	g.drawString(S,x+4,y+h-3);
    }

    public int inside(Point p) {
	int test=0;
	if((p.x>x)&&(p.x<x+w)&&(p.y>y)&&(p.y<y+h)) test=1;
	return(test);
    }

    public void activate(Point p) {
	int test=inside(p);
	if(test==1) ON=true;
	if(test==0) ON=false;
    }

    public void modify(Point p) {
	if(ON==true) pos=1.0*p.x;;
    }

    public double getValue() {
	double d=1.0*(pos-x)/w;
	return(d);
    }

    public void forceValue(double d) {
	pos=x+d*w;
    }

}