import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of nxn matrices.  Here n<10 */


public class Matrix {
    double[][] a=new double[10][10];
    int size;
    int[] data=new int[2];  //for Gaussian elimination


    public Matrix(){}

    public Matrix(double[][] aa,int s) {
	this.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		System.out.println(i+" "+j+"   "+a[i][j]);
		this.a[i][j]=aa[i][j];
	    }
	}
    }

    public Matrix(Matrix m) {
	this.size=m.size;
	this.data=m.data;
	for(int i=0;i<m.size;++i) {
	    for(int j=0;j<m.size;++j) {
		this.a[i][j]=m.a[i][j];
	    }
	}
    }


    public static Matrix times(Matrix M1,Matrix M2) {
	int s=M1.size;
	Matrix M=new Matrix();
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		M.a[i][j]=0;
		for(int k=0;k<s;++k) {
		    M.a[i][j]=M.a[i][j]+M1.a[i][k]*M2.a[k][j];
		}
	    }
	}
	M.size=s;
	return(M);
    }


    /**special matrices**/


    /**THe identity**/

    public static Matrix identity(int s) {
	Matrix m=new Matrix();
	m.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		m.a[i][j]=0;
		if(i==j) m.a[i][j]=1;
	    }
	}
	return(m);
    }


    /**a random matrix*/

    public static Matrix random(int s) {
	Matrix m=new Matrix();
	m.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		m.a[i][j]=Math.random();
	    }
	}
	return(m);
    }

    /**A random matrix with integer entries between -N and N*/

    public static Matrix randomInt(int s,int N) {
	Matrix m=random(s);
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		m.a[i][j]=Math.floor(2*N*m.a[i][j]-N);
	    }
	}
	return(m);
    }


    /**basic operations**/

    public Matrix transpose() {

	Matrix TM=new Matrix();
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		TM.a[j][i]=a[i][j];
	    }
	}
	TM.size=size;
	return(TM);
    }

    public double trace() {
	double t=a[0][0]+a[1][1]+a[2][2];
	return(t);
    }

    public static Vector act(Matrix M,Vector V) {
	if(M==null) return(null);
	if(V==null) return(null);
	int s=M.size;
	Vector W=new Vector();
	W.size=M.size;
	for(int i=0;i<s;++i) {
	    W.x[i]=0;
	    for(int j=0;j<s;++j) {
		W.x[i]=W.x[i]+M.a[i][j]*V.x[j];
	    }
	}
	return(W);
    }

    public Vector row(int j) {
	Vector v=new Vector();
	v.size=this.size;
	for(int i=0;i<size;++i) v.x[i]=this.a[j][i];
	return(v);
    }

    public static double det(Matrix M) {
	Matrix m=new Matrix(M);
	m.data[0]=0;
	m.data[1]=0;
	for(int i=0;i<m.size;++i) m=GaussianElimination.step(m);
	double d=1;
	for(int i=0;i<m.size;++i) d=d*m.a[i][i];
	if(m.data[1]%2==1) d=-d;
	return(d);
    }


    public static Matrix inverse(Matrix m) {
	Matrix[] M=new Matrix[2];
	M[0]=new Matrix(m);
	M[0].data[0]=0;
	M[0].data[1]=0;
	M[1]=identity(m.size);
	for(int i=0;i<m.size;++i) {
           M=GaussianElimination.step(M);
	}
	if(M==null) return(null); //singular matrix
	for(int i=0;i<m.size;++i) {
	    for(int j=0;j<m.size;++j) {
		M[1].a[i][j]=M[1].a[i][j]/M[0].a[i][i];
	    }
	}
	return(M[1]);
    }



    /**printing**/

    public void print() {

	System.out.println("matrix");
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		double d=nearInt(a[i][j]);
		System.out.print(d+" ");
	    }
	    System.out.println("");
	}
	System.out.println("---------");
    }

    public static double nearInt(double s) {
	for(int i=-1000;i<1000;++i) {
	    if(Math.abs(s-i)<.000000000001) return(i);
	}
	return(s);
    }




    public void mathPrint() {
	System.out.print("M={{");
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		if(j<size-1) System.out.print(a[i][j]+",");
		if(j==size-1) System.out.print(a[i][j]+"}");
	    }
	    if(i<size-1) System.out.print(",{");
	}
	System.out.println("}");
    }




}




