import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;

/**This class helps navigate the partition**/



public class Navigator {
    Manager M;
    Vector[] FRAME=new Vector[3];
    int x,y;
    ListenSquare KITE1;  //kite -1 eigenspace
    ListenSquare KITE2;  //kite +1 eigenspace: rectangle picture
    ListenSquare KITE3;  //THIS MATCHES THE X-SLICE OF THE MAIN PROGRAM!
    HSlider[] POS=new HSlider[5];
    HSlider[] LEFT=new HSlider[5];
    HSlider[] RIGHT=new HSlider[5];
    HSlider SLICE;
    ListenSquare INFO;
    int STATE;

    public Navigator(int xx,int yy) { 
         x=xx;
	 y=yy;	
	 double[] f0={0,0,0,0,0};
	 double[] f1={1,0,0,0,0};
	 double[] f2={0,1,0,0,0};
	 FRAME[0]=new Vector(f0);
	 FRAME[1]=new Vector(f1);
	 FRAME[2]=new Vector(f2);
	 makeControls();
	 STATE=0;

    }



    public void copyPlane(Plane P) {
	FRAME[0]=P.V[0];
	FRAME[1]=P.V[1];
	FRAME[2]=P.V[2];
	toSlider();
    }

    public void makeControls() {
	 KITE1=new ListenSquare(x+350,y+5,35,20,null);KITE1.on=1;
	 KITE2=new ListenSquare(x+390,y+5,65,20,null);KITE2.on=1;
	 KITE3=new ListenSquare(x+460,y+5,85,20,null);KITE3.on=1;
	 INFO=new ListenSquare(5,5,12,12);


	 String S="";
	 Color[] COL1={new Color(100,0,180),Color.blue,Color.white,Color.white};
	 Color[] COL2={new Color(200,0,200),Color.blue,Color.white,Color.white};
	 Color[] COL3={new Color(0,180,0),Color.blue,Color.white,Color.white};

	 for(int i=0;i<5;++i) {
	     POS[i]=new HSlider(10,150+23*i,630,20,320,COL1,S);
	     LEFT[i]=new HSlider(10,30+23*i,310,20,160,COL3,S);
	     RIGHT[i]=new HSlider(330,30+23*i,310,20,480,COL3,S);
	 }
	 SLICE=new HSlider(10,270,630,20,320,COL2,S);
    }

   public void render(Graphics g2) {
         Graphics2D g=(Graphics2D) g2;
         g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
	 drawBG(g);
	 drawControls(g);
   }


    public void drawControls(Graphics2D g) { 
	g.setColor(Color.yellow);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString("preset slices: ",x+260,y+20);

	Color C1=new Color(50,0,100);
	Color C2=new Color(50,100,255);
	Color[] COL={C1,C1,C1,C1};
	COL[STATE]=C2;
	KITE1.render(g,COL[1]);
	KITE2.render(g,COL[2]);
	KITE3.render(g,COL[3]);
	INFO.infoRender(g);
	g.setColor(Color.white);
	g.drawString("kite",x+355,y+20);
	g.drawString("rectangle",x+395,y+20);
	g.drawString("X slice match",x+465,y+20);
	for(int i=0;i<5;++i) POS[i].render(g);
	for(int i=0;i<5;++i) LEFT[i].render(g);
	for(int i=0;i<5;++i) RIGHT[i].render(g);
	SLICE.render(g);

	g.setColor(new Color(255,190,255));
	g.fillRect(320,270,1,20);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString("compare to (+) partition",20,285);
	g.drawString("compare to (-) partition",340,285);
    }


    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,100));
	g.fillRect(x+20,y,660,y+390);
	g.setColor(Color.white);
	g.drawRect(x+20,y,660,y+390);
    }

    public Plane getPlane(Manager M) {
	Plane P=new Plane();
	P.size=5;
	for(int i=0;i<3;++i) P.V[i]=new Vector(FRAME[i]);
	return(P);
    }

    /**special positions**/
    public void forceQTCFoliation(Manager M) {
	STATE=1;
	double a=0;
	a=M.C.SES1.getParameter();
	int[] q={1,1,0,1};
	double[] r=QTCKite.getR(a,a);
	double[] r1={1/r[0],1/r[1],1/r[2],1/r[3],0};
	double[] r2={0,0,0,0,1};
	for(int i=0;i<5;++i) {
	    r1[i]=.5*r1[i];
	    r2[i]=.5*r2[i];
	}

	FRAME[0]=Torus.psiDomain(q,a,M.P.SOURCE);
	FRAME[1]=new Vector(r1);
	FRAME[2]=new Vector(r2);
	toSlider();
    }


    public void forceRectanglePicture(Manager M) {
	STATE=2;
	double a=0;
	a=M.C.SES1.getParameter();
	int[] q={1,1,0,1};
	double[] r=QTCKite.getR(a,a);
	double[] r1={0,1,-2/(1+a),1,0};
	double[] r2={1,-1,0,-1,1};
	for(int i=0;i<5;++i) {
	    r1[i]=.5*r1[i];
	    r2[i]=.5*r2[i];
	}
	FRAME[0]=Torus.psiDomain(q,a,M.P.SOURCE);
	FRAME[1]=new Vector(r1);
	FRAME[2]=new Vector(r2);
	toSlider();
    }


    public void forceXMatch(Manager M) {
	STATE=3;	
        double a=0;
	a=M.C.SES1.getParameter();
	double[] r=QTCKite.getR(a,a);
	double[] r1={0,1,(a-1)/(a+1),1,0};
	double[] r2={0,0,1,0,0};


	for(int i=0;i<5;++i) {
	    r1[i]=.5*r1[i];
	    r2[i]=.5*r2[i];
	}
	int[] q={1,1,0,1};
	FRAME[0]=Torus.psiDomain(q,a,M.P.SOURCE);
	FRAME[1]=new Vector(r1);
	FRAME[2]=new Vector(r2);
	toSlider();
    }

    public void forceKiteNeutral(Manager M) { 
        double a=0;
	a=M.C.SES1.getParameter();
	int[] q={1,1,0,1};
	double[] r=QTCKite.getR(a,a);
	FRAME[0]=Torus.psiDomain(q,a,M.P.SOURCE);
	toSlider();
    }




    public void tryKite(Point X,Manager M) {
	if(KITE1.inside(X)==1)	forceQTCFoliation(M);
	if(KITE2.inside(X)==1)	forceRectanglePicture(M);
	if(KITE3.inside(X)==1)	forceXMatch(M);
    }

    public void preProcess(MouseEvent e,Manager M) {
	MouseData J=MouseData.process(e);
	for(int i=0;i<5;++i) {
	    POS[i].ON=false;
	    POS[i].activate(J.X);
	    LEFT[i].ON=false;
	    LEFT[i].activate(J.X);
	    if(LEFT[i].ON==true) STATE=0;
	    RIGHT[i].ON=false;
	    RIGHT[i].activate(J.X);
	    if(RIGHT[i].ON==true) STATE=0;
	}
	SLICE.ON=false;
	SLICE.activate(J.X);
    }


    public void process(MouseEvent e,Manager M) {
	MouseData J=MouseData.process(e);
	tryKite(J.X,M);
	for(int i=0;i<5;++i) {
	    if(POS[i].ON==true) POS[i].modify(J.X);
	    if(LEFT[i].ON==true) LEFT[i].modify(J.X);
	    if(RIGHT[i].ON==true) RIGHT[i].modify(J.X);
	}
	if(SLICE.ON==true) {
            SLICE.modify(J.X);
	    fromSpecial(M);
	}
	fromSlider();
	if(INFO.inside(J.X)==1) DocumentControl.navigator(M.D);
    }

    public void fromSpecial(Manager M) {
	double a=M.C.SES1.getParameter();
	double t=SLICE.getValue();
        t=t-.5;
	FRAME[0].x[0]=t;
	FRAME[0].x[1]=-t;
	FRAME[0].x[3]=-t;
	FRAME[0].x[4]=t+.5;
	if(t>=0) FRAME[0].x[4]=t-.5;
	toSlider();
    }



    public void fromSlider() {
	for(int i=0;i<5;++i) {
	    double t=POS[i].getValue();
	    t=t-.5;
	    t=2*t;
	    FRAME[0].x[i]=t;
	    t=LEFT[i].getValue();
	    t=t-.5;
	    t=2*t;
	    FRAME[1].x[i]=t;
	    t=RIGHT[i].getValue();
	    t=t-.5;
	    t=2*t;
	    FRAME[2].x[i]=t;

	}
    }


    public void toSlider() {
	for(int i=0;i<5;++i) {
	    double t=FRAME[0].x[i];
	    t=.5*t+.5;
	    POS[i].forceValue(t);
	    t=FRAME[1].x[i];
	    t=.5*t+.5;
	    LEFT[i].forceValue(t);
	    t=FRAME[2].x[i];
	    t=.5*t+.5;
	    RIGHT[i].forceValue(t);
	}
    }



}

