import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class PETCanvas extends ScaleCanvas implements KeyListener, MouseListener, MouseMotionListener {
    Manager M; 
    PolygonWrapper P1,P2;
    Parallelotope[] X1=new Parallelotope[10000];
    Parallelotope[] X2=new Parallelotope[10000];
    Color[] COLOR=new Color[10000];
    int COUNT=0;
    ComputePolytope CP;
    Point KEY;

     public PETCanvas() {
	 addKeyListener(this);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,200,150);	
	 CP=new ComputePolytope();
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTiles(g);
      if(M.C.COLOR3.L[1].on==1) drawAxes(g);
      drawSource(g);
      drawStats(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.COLOR3.M[0].C);
	g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawStats(Graphics2D g) {
	Integer S=new Integer(COUNT);
	g.setColor(Color.white);
	g.drawString(S.toString(),15,15);
    }


    public void drawTiles(Graphics2D g) {
	int[] k={0,0,0,0,0};
	drawPartition(g);
	drawPolytopes(g);
    }

    public void drawPolytopes(Graphics2D g) {
	Plane P=new Plane();
	double a=0;
        P=M.S.SLICE.getPlane(M);
	a=M.C.SES1.getParameter();
	P.V[0]=Torus.toDomain1(a,P.V[0]);
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<COUNT;++i) {
	    gp.reset();
	    try{
	       PolygonWrapper I1=Plane.intersect(P,X1[i]);
	       PolygonWrapper I2=Plane.intersect(P,X2[i]);
	       PolygonWrapper I3=ConvexIntersect.intersect(I1,I2);
	       gp=I3.toPath();
	       gp=transform(gp);
	    }
	    catch(Exception e) {}
	    g.setColor(COLOR[i]);
	    g.fill(gp);
	    g.setColor(Color.white);
	    g.draw(gp);
	}
    }


    public void drawAxes(Graphics2D g) {
	  Path2D.Double gp=new Path2D.Double();

	  gp.moveTo(-1,0);
	  gp.lineTo(1,0);
	  gp.moveTo(0,1);
	  gp.lineTo(0,-1);
	  gp=transform(gp);
	  g.setColor(M.C.COLOR3.M[1].C);
	  g.draw(gp);
    }

    /**This draws the extended partition.   We are taking
       the intersection Z^5(X1) # L(Z^5)(X2).  This is the
       common refinement of the partition of R5 by Z^5
       translates of X1 and the partition of R5 by L(Z^5)
       translates of X2.*/

    public void drawPartition(Graphics2D g) {
	int m=M.C.TILE.mode;
	int dir=M.C.DIRECTION.mode;
	if(m==0) drawPartitionSmall(g);
	if((dir==0)&&(m==1)) drawPartitionMediumForeward(g);
	if((dir==1)&&(m==1)) drawPartitionMediumBackward(g);
	if((dir==0)&&(m==2)) drawPartitionLargeForeward(g);
	if((dir==1)&&(m==2)) drawPartitionLargeBackward(g);
    }


    public void drawPartitionSmall(Graphics2D g) {
	Plane P=M.S.SLICE.getPlane(M);
	drawPartition(g,P,new Vector(0,0,0,0,0));
    }

    public void drawPartitionMediumForeward(Graphics2D g) {
	Plane P=M.S.SLICE.getPlane(M);
	for(int i=-1;i<=1;++i) {
	    Vector TRANS=new Vector(0,0,0,i,0);
	    drawPartition(g,P,TRANS);
	}
    }

    public void drawPartitionMediumBackward(Graphics2D g) {
	Plane P=M.S.SLICE.getPlane(M);
	for(int i1=-1;i1<=1;++i1) {
	for(int i2=-1;i2<=1;++i2) {
	    Vector TRANS=new Vector(i1,i2,0,0,0);
	    drawPartition(g,P,TRANS);
	}}
    }

    public void drawPartitionLargeForeward(Graphics2D g) {
	Plane P=M.S.SLICE.getPlane(M);
	int lim=M.C.TILE.mode;
	for(int i1=0;i1<=1;++i1) {
	for(int i2=0;i2<=1;++i2) {
	for(int i3=0;i3<=1;++i3) {
	for(int i4=-1;i4<=1;++i4) {
	    Vector TRANS=new Vector(i1,i2,i3,i4,0);
	    drawPartition(g,P,TRANS);
	}}}}
    }

    public void drawPartitionLargeBackward(Graphics2D g) {
	Plane P=M.S.SLICE.getPlane(M);
	int lim=M.C.TILE.mode;
	for(int i1=-1;i1<=1;++i1) {
	for(int i2=-1;i2<=1;++i2) {
	for(int i3=-1;i3<=1;++i3) {
	for(int i4=-1;i4<=1;++i4) {
	    Vector TRANS=new Vector(i1,i2,i3,i4,0);
	    drawPartition(g,P,TRANS);
	}}}}
    }


    /**This draws the basic partition in the
       fundamental domain then translates the
       result by the integer vector TRANS*/


    public void drawPartition(Graphics2D g,Plane P,Vector TRANS) {
	double a=0;
        a=M.C.SES1.getParameter();
	int dir=M.C.DIRECTION.mode;
        Parallelotope X1=Parallelotope.X1(a);
        if(dir==1) X1=Parallelotope.X2(a);
	Plane TRANSP=P.translateBy(TRANS);
        PolygonWrapper W1=Plane.intersect(TRANSP,X1);

        Parallelotope X2=Parallelotope.X2(a);
        if(dir==1) X2=Parallelotope.X1(a);
        for(int i0=-1;i0<=1;++i0) {
        for(int i1=-1;i1<=1;++i1) {
        for(int i2=-1;i2<=1;++i2) {
        for(int i3=-1;i3<=1;++i3) {
            int[] ii={i0,i1,i2,i3,0};
            Vector TT=new Vector(ii);
            TT=Matrix.act(Torus.L(a),TT);
            Plane Q=new Plane(P);
	    Plane TRANSQ=Q.translateBy(TRANS);
            TRANSQ=TRANSQ.translateBy(TT);
            PolygonWrapper W2=Plane.intersect(TRANSQ,X2);
            PolygonWrapper W=ConvexIntersect.intersect(W1,W2);
	    int test=i1+i2+i3;
	    if(test<0) test=-test;

	   if((test<2)&&(W!=null)) {
           Path2D.Double gp=W.toPath();
           gp=transform(gp);
           int[] move={-i1-i2-i3,-i2};
	   int mode=M.C.COLOR3.L[2].on;
	   Color[] C={M.C.COLOR3.M[2].C,new Color(100,100,100)};
	   if(mode==1) C=ControlColor.getColor(move);
	   g.setColor(C[0]);
           g.fill(gp);
           g.setColor(C[1]);
           g.draw(gp);
        }
        }}}}
    }


    public boolean testInteger(Vector V) {
	for(int i=0;i<5;++i) {
	    double test=Torus.fp(V.x[i]);
	    if(Math.abs(test)>.0000001) return(false);
	}
	return(true);
    }



    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	repaint();
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(KEY,0);
        if(mode==3)  scaleUp(KEY,1);
	repaint();
    }


     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	KEY=J.X;
     }
     public void mouseDragged(MouseEvent e) {
     }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }
}
