import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


/**This class describes a parallelotope.  Here is the data:
   M is a matrix whose columns are linear functionals
   V[0], V[1] are vectors such that the parallelotope consists
   of all vectors X such that M.X lies between V[0] and V[1]
   coordinatewise.
   DIM is the dimension of the ambient space*/


public class Parallelotope {

    Matrix M;
    Vector[] V=new Vector[2];
    int size;

    public Parallelotope() {}

    public Parallelotope(Parallelotope P) {
	this.M=new Matrix(P.M);
	this.V[0]=new Vector(P.V[0]);
	this.V[1]=new Vector(P.V[1]);
	this.size=P.size;
    }


    public void print() {
	M.print();
	V[0].print();
	V[1].print();
    }


    public static Parallelotope X1(double a) {
	Parallelotope P=new Parallelotope();
	P.M=Torus.X1(a);
	Vector W=new Vector();
	W.size=5;
	for(int i=0;i<5;++i) W.x[i]=-.5;
	P.V[0]=new Vector(W);
	for(int i=0;i<5;++i) W.x[i]=.5;
	P.V[1]=new Vector(W);
	return(P);
    }

    public static Parallelotope X2(double a) {
	Parallelotope P=new Parallelotope();
	P.M=Torus.X2(a);
	Vector W=new Vector();
	W.size=5;
	for(int i=0;i<5;++i) W.x[i]=-.5;
	P.V[0]=new Vector(W);
	for(int i=0;i<5;++i) W.x[i]=.5;
	P.V[1]=new Vector(W);
	return(P);
    }

    /**This locates the point within the tilings**/

    public static Vector locate1(double a,Vector W) {
	Matrix M=Torus.X1(a);
	Vector X=Matrix.act(M,W);
	return(X);
    }

    public static Vector locate2(double a,Vector W) {
	Matrix M=Torus.X2(a);
	Vector X=Matrix.act(M,W);
	return(X);
    }
    /**checks if the standard width parallelotope contains the point*/

    public boolean contains(Vector v) {
	Vector w=Matrix.act(M,v);
	for(int i=0;i<5;++i) {
	    if(w.x[i]<V[0].x[i]) return(false);
	    if(w.x[i]>V[1].x[i]) return(false);
	}
	return(true);
    }





    /**This creates the translate of the first parallelotope
       centered at the vector V*/

    public Parallelotope translateBy(Vector V) {
	Parallelotope P=new Parallelotope(this);
	Vector W=Matrix.act(M,V);
	P.V[0]=Vector.plus(P.V[0],W);
	P.V[1]=Vector.plus(P.V[1],W);
	return(P);
    }


}



