import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    Path2D.Double[] TILE=new Path2D.Double[100000];
    Color[] COLOR=new Color[100000];
    int[][] TYPE=new int[100000][3];
    int COUNT=0;
    ComputeTile CT;
    ComputePolytope CP;
    Point KEY;
    String MESSAGE;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(10,130,200);
	 MESSAGE="";
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTiles(g);
      displaySource(g);
      if(M.C.COLOR1.L[2].on==1) drawDelta(g);
      if(M.C.COLOR1.L[3].on==1) drawCursor(g);
      drawMessage(g);
   }

    public Color getMessageColor() {
        Color C=M.C.COLOR1.M[0].C;
        int a1=C.getRed();
        int a2=C.getGreen();
        int a3=C.getBlue();
        if(a1+a2+a3>500) return(Color.black);
	return(Color.white);
    }


    public void drawMessage(Graphics2D g) {
       g.setFont(new Font("Helvetica",Font.PLAIN,12));
       g.setColor(getMessageColor());
       g.drawString(MESSAGE,140,15);
    }

    public void drawBG(Graphics2D g) {

	g.setColor(new Color(0,0,100));
	try {g.setColor(M.C.COLOR1.M[0].C);}
	catch(Exception e) {}
	g.fillRect(0,0,getWidth(),getHeight());

	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(-100,-.5);
	gp.lineTo(100,-.5);
	gp.lineTo(100,.5);
	gp.lineTo(-100,.5);
	gp=transform(gp);
	g.setColor(Color.black);
	try {g.setColor(M.C.COLOR1.M[1].C);}
	catch(Exception e) {}
	g.fill(gp);

	gp.reset();
	gp.moveTo(-100,-.5);
	gp.lineTo(100,-.5);
	gp.moveTo(-100,.5);
	gp.lineTo(100,.5);
	gp.moveTo(0,-.5);
	gp.lineTo(0,.5);
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);

    }


    public void drawDelta(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	for(int j=-20;j<20;j=j+2) {
	  gp.reset();
	  gp.moveTo(.5+.5*j,-.5);
	  gp.lineTo(1.5+.5*j,+.5);
	  gp=transform(gp);
	  g.setColor(M.C.COLOR1.M[2].C);
	  g.draw(gp);
	}
    }

    public void displaySource(Graphics2D g) {
	drawSource(g);
	Color C=getMessageColor();
	GraphicsHelper.cleanDouble(g,SOURCE.x,10,13,C);
	GraphicsHelper.cleanDouble(g,SOURCE.y,10,26,C);
	int[] q5=M.C.getBinary();
	int[] q=new int[4];
	for(int i=0;i<4;++i) q[i]=q5[i];
	double a=M.C.SES1.getParameter();
    }

    public void drawCursor(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	  gp.moveTo(-1,0);
	  gp.lineTo(1,0);
	  gp.moveTo(0,1);
	  gp.lineTo(0,-1);
	  AffineTransform A=AffineTransform.getTranslateInstance(SOURCE.x,SOURCE.y);
	  gp.transform(A);
	  gp=transform(gp);
          g.setColor(M.C.COLOR1.M[3].C);
	  g.draw(gp);
    }



    public void drawTiles(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<COUNT;++i) {
	    Color[] C={COLOR[i],Color.white};
	    gp=new Path2D.Double(TILE[i]);
	    gp=transform(gp);
	    g.setColor(C[0]);
	    g.fill(gp);
	    g.setColor(C[1]);
	    g.draw(gp);
	}
    }


    public void regionPlot(boolean cautious) {
	boolean test=true;
	if(cautious==true) {
	    int index=tileIndex();
	    if(index>-1) test=false;
	}

	int v=M.C.ACTION.L[0].on;
	if((test==true)&&(v==0)) {
	  CT=new ComputeTile(M);
	  new Thread(CT).start();
	  CP=new ComputePolytope(M);
	  new Thread(CP).start();
	}
    }

    public int tileIndex() {
	for(int i=0;i<COUNT;++i) {
	    if(TILE[i].contains(SOURCE.x,SOURCE.y)==true) return(i);
	}
	return(-1);
    }






    public void setView() {
	try{ M.S.SLICE.forceKiteNeutral(M);}
	catch(Exception e) {}
    }

    public void mouseClicked(MouseEvent e) {
      MouseData J=MouseData.process(e);
      doMouseClick(J.mode);
    }



    public Complex coerceKite(Complex z) {
	double x=Math.floor(z.x+.5);
	Complex w=new Complex(z.x-x,z.y);
	w=coerceKite0(w);
	w.x=w.x+x;
	return w;
    }

    public Complex coerceKite0(Complex z) {
	double x=z.x;
	double y=z.y;
	double t=(x+y)/2;
	Complex w=new Complex(t,t);
	return w;
    }

    public void setSource(Point X) {
	Complex temp=unTransform(X);
	if(temp.y<-.5) return;
	if(temp.y>.5) return;
	int m=M.C.KITE.mode;
	if(m==0) SOURCE=temp;
	if(m==1) SOURCE=coerceKite(temp);
    }



    public void mousePressed(MouseEvent e) {}

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(KEY,0);
        if(mode==3)  scaleUp(KEY,1);
	if(mode==2)  {
             setSource(KEY);
	     regionPlot(false);
	}
	setView();
	M.repaint();
    }

    /**For dragging*/
    public void doMouseClickShort(int mode) {
	if(mode==2) {
           setSource(KEY);
	   regionPlot(true);
	}
	setView();
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {}   

    public void mouseMoved(MouseEvent e) {
      MouseData J=MouseData.process(e);
      KEY=J.X;
    }

  
     public void mouseDragged(MouseEvent e) { 
      MouseData J=MouseData.process(e); 
      KEY=J.X;
      doMouseClickShort(J.mode);
     }


    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }
}

