import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


/**This class describes a plane.  Here is the data:
   V[0] is a point on the plane.
   V[1] is a vector in the plane.
   V[2] is a vector in the plane, independent from V[1].
   size is the dimension of the ambient space*/


public class Plane {

    Vector[] V=new Vector[3];
    int size;

    public Plane() {}

    public Plane(Plane P) {
	for(int i=0;i<3;++i) this.V[i]=new Vector(P.V[i]);
	this.size=P.size;
    }


    /**A random plane*/

    public static Plane random(int size) {
	Plane P=new Plane();
	for(int i=0;i<3;++i) P.V[i]=Vector.random(size);
	P.size=size;
	return(P);
    }

    public static Plane randomInt(int size,int n) {
	Plane P=new Plane();
	for(int i=0;i<3;++i) P.V[i]=Vector.randomInt(size,n);
	P.size=size;
	return(P);
    }


    public void print() {
	System.out.println("plane");
	V[0].print();
	V[1].print();
	V[2].print();
    }


    /**Moving a plane around**/

    public Plane coordinateSwap(int q0,int q1) {
	Plane P=new Plane();
	P.size=size;
	for(int i=0;i<3;++i) {
	    P.V[i]=V[i].coordinateSwap(q0,q1);
	}
	return(P);
    }

    public Plane translateBy(Vector W) {
	Plane P=new Plane(this);
	P.V[0]=Vector.plus(P.V[0],W);
	return(P);
    }


    /**getting a point in the plane*/

    public Vector getPoint(Complex z) {
	 Vector W=new Vector();
	 W.size=V[0].size;
	 for(int i=0;i<W.size;++i) {
	     W.x[i]=V[0].x[i]+z.x*V[1].x[i]+z.y*V[2].x[i];
	 }
	 return(W);
     }


    /**This routine computes the intersection of a
       plane with the subspace of R^n given by x_0=x_1=0.*/

     public static Complex intersect(Plane P) {
	 Matrix M=new Matrix();
	 M.size=2;
	 M.a[0][0]=P.V[1].x[0];
	 M.a[0][1]=P.V[2].x[0];
	 M.a[1][0]=P.V[1].x[1];
	 M.a[1][1]=P.V[2].x[1];
	 M=Matrix.inverse(M);
	 Vector V=new Vector(P.V[0]);
	 V.x[0]=-P.V[0].x[0];
	 V.x[1]=-P.V[0].x[1];
	 V.size=2;
	 V=Matrix.act(M,V);
	 if(V==null) return(null);
	 Complex z=new Complex(V.x[0],V.x[1]);
         return(z);
     }

    /**This routine computes the intersection of a
       plane with the subspace of R^n given by x0=d0, x1=d1**/


    public static Complex intersect(Plane P,double d0,double d1) {
	Vector W=new Vector();
	W.x[0]=-d0;
	W.x[1]=-d1;
	W.size=P.size;
	Plane Q=P.translateBy(W);
	return(intersect(Q));
    }


    /**This routine computes the intersection of a
       plane with the subspace of R^n given by

       x_{q0}=d0, x_{q1}=d1. **/

    public static Complex intersect(Plane P,int q0,int q1,double d0,double d1) {
	Plane Q=P.coordinateSwap(q0,q1);

	double dd0=d0;
	double dd1=d1;
	if(q0==1) {
	    dd0=d1;
	    dd1=d0;
	}

	Complex z=intersect(Q,dd0,dd1);
	return(z);
    }

    /**This routine computes the intersection of a plane with the unit cube
       centered at the origin.**/

    public static PolygonWrapper intersectUnitCube(Plane P) {
	int n=P.size;
	Vector V1=new Vector(n);
	Vector V2=new Vector(n);

	for(int i=0;i<n;++i) {
	    V1.x[i]=.5;
	    V2.x[i]=.5;
	}
	return(intersectGeneralCube(P,V1,V2));
    }

    /**This routine computes the intersection of a plane with the unit cube
       centered at the origin.**/

    public static PolygonWrapper intersectGeneralCube(Plane P,Vector V1,Vector V2) {
	if(V1.size!=P.size) return(null);
	if(V2.size!=P.size) return(null);
	int n=P.size;
	int N=4*n*(n-1);
	Complex[] Z=new Complex[N];
	int count=0;
	Complex z=new Complex();


	for(int i=0;i<n;++i) {
	    for(int j=i+1;j<n;++j) {

		int temp=0;
		z=intersect(P,i,j,V1.x[i],V1.x[j]);
		if(z!=null) {
		    Z[count+temp]=new Complex(z); ++temp;
		}

		z=intersect(P,i,j,V1.x[i],V2.x[j]);
		if(z!=null) {
		    Z[count+temp]=new Complex(z); ++temp;
		}

		/**HERE DEBUG**/
		z=intersect(P,i,j,V2.x[i],V1.x[j]);
		if(z!=null) {
		    Z[count+temp]=new Complex(z); ++temp;
		}

		z=intersect(P,i,j,V2.x[i],V2.x[j]);
		if(z!=null) {   
                    Z[count+temp]=new Complex(z); ++temp;
		}
		count=count+temp;
	    }
	}

	if(count==0) return(null);
	PolygonWrapper X=new PolygonWrapper();
	X.count=0;
	for(int i=0;i<count;++i) {
	    Vector U=P.getPoint(Z[i]);
	    boolean test=true;
	    for(int j=0;j<V1.size;++j) {
		if(U.x[j]<V1.x[j]-.00000001) test=false;
		if(U.x[j]>V2.x[j]+.00000001) test=false;
	    }
	    if(test==true) {
		X.z[X.count]=new Complex(Z[i]);
		++X.count;
	    }
	}
	X=ConvexHull.convexHull(X);
	return(X);
    }


    /**This computes the intersection of a plane with a parallelotope**/
    public static PolygonWrapper intersect(Plane P,Parallelotope X) {
	Matrix m=new Matrix(X.M);
	Plane Q=new Plane();
	Q.size=P.size;
	for(int i=0;i<3;++i) Q.V[i]=Matrix.act(m,P.V[i]);
	return(intersectGeneralCube(Q,X.V[0],X.V[1]));
    }


}

