import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class QTCGeneral {

    /**This function either takes the floor or the nearest
       integer, depending on the first argument:
       q=0 gives nearest integer
       q=1 gives floor **/


     public static double cutoff(int q,double x) {
	 double y=0;
	 if(q==0) y=Math.floor(x+.5);
	 if(q==1) y=Math.floor(x);
	return(y);
    }


    /**The range for this map is R times [-1/2,1/2]*/

    public static Complex basicMap(Complex z) {
	double x0=cutoff(0,z.x);
	double x1=z.x-x0;
	double y1=z.y;
	double x2=x0+y1;
	double y2=-x1;
	return(new Complex(x2,y2));
    }

    public static Complex qTurn(int q,double r,Complex z) {
	if(q==0) return(qTurn0(r,z));
	return(qTurn1(r,z));
    }



    public static Complex qTurn0(double r,Complex z) {
	Complex w=new Complex(z.x/r,z.y);
	w=basicMap(w);
	w.x=r*w.x;
	return(w);
    }


    public static Complex qTurn1(double r,Complex z) {
	Complex T=new Complex(r/2,0);
	Complex z1=Complex.plus(z,T);
	z1=qTurn0(r,z1);
	z1=Complex.minus(z1,T);
	return(z1);
    }


    /**This is the shear**/

    public static Complex shear(double s,Complex z) {
	Complex w=new Complex(z.x-s*z.y,z.y);
	return(w);
    }


    /**this does the QTC, given parameters q,r,s**/

    public static Complex QTC(int[] q,double[] r,double[] s,Complex z) {
	int n=q.length;
	Complex z0=new Complex(z);
	for(int i=0;i<n;++i) {
	    z0=qTurn(q[i],r[i],z0);
	    z0=shear(s[i],z0);
	}
	return(z0);
    }

    /**This routine computes the ariathmetic graph.  It is based
       on the square of the map*/

    public static int[] graph(int[] q,double[] r,double[] s,Complex z) {
	int n=q.length;
	Complex z0=new Complex(z);
	double[] P=new double[2*n];
	for(int i=0;i<2*n;++i) {
	    P[i]=cutoff(q[i%n],z0.x/r[i%n]);
	    z0=qTurn(q[i%n],r[i%n],z0);
	    z0=shear(s[i%n],z0);
	}
	int[] Q=new int[n];
	for(int i=0;i<n;++i) {
	    Q[i]=(int)(P[i+n]-P[i]);
	}
	return(Q);
    }




    /**These routines have to do with finding the tiling*/

    /**This detects the position in the square, in the order
       east, south, west, north**/

    public static double[] squarePosition(int q,Complex z) {
	double x0=cutoff(q,z.x);
	double x=z.x-x0;
	double y=z.y;

	double[] A0={.5-x,y+.5,x+.5,.5-y};
	double[] A1={ 1-x,y+.5,x,   .5-y};
	if(q==0) return(A0);
	return(A1);
    }


    /**This detects the position in the rectangle, in the order
       east, south, west, north**/

    public static double[] rectanglePosition(int q,double r,Complex z) {
	Complex w=new Complex(z.x/r,z.y);
	double[] A=squarePosition(q,w);
	A[0]=A[0]*r;
	A[2]=A[2]*r;
	return(A);
    }

    public static double[][] mapPosition(int[] q,double[] r,double[] s,Complex z) {
	int n=q.length;
	Complex w=QTC(q,r,s,z);
	double[][] A1=mapPosition0(q,r,s,z);
	double[][] A2=mapPosition0(q,r,s,w);
	A2=rotate(A2,n);
	double[][] A=minimize(A1,A2,n);
	return(A);
    }

    public static double[][] mapPosition0(int[] q,double[] r,double[] s,Complex z) {
	int n=q.length;
	double[][] A=new double[n][4];
	Complex z0=new Complex(z);
	for(int i=0;i<n;++i) {
	  A[i]=rectanglePosition(q[i],r[i],z0);
	  z0=qTurn(q[i],r[i],z0);
	  z0=shear(s[i],z0);
	}
	double[] Y=rectanglePosition(q[0],r[0],z0);
	A[0][1]=Math.min(A[0][1],Y[3]);
	A[0][3]=Math.min(A[0][3],Y[1]);
	return(A);
    }

    public static double[][] minimize(double[][] A1,double[][] A2,int n) {
	double[][] A=new double[n][4];
	for(int i=0;i<n;++i) {
	    for(int j=0;j<4;++j) {
		A[i][j]=Math.min(A1[i][j],A2[i][j]);
		if(A[i][j]<0) System.out.println("bad");
	    }
	}
	return(A);
    }

    public static double[][] rotate(double[][] A1,int n) {
	double[][] A2=new double[n][4];
	for(int i=0;i<n;++i) {
	    A2[i][0]=A1[i][2];
	    A2[i][1]=A1[i][3];
	    A2[i][2]=A1[i][0];
	    A2[i][3]=A1[i][1];
	}
	return(A2);
    }

}

