import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This does the quarter turn composition associated to the kite*/

public class QTCKite {

    /**{1,1,0,1} is the outer billiards choice*/

    public static Complex map(int[] q,double a0,double a1,Complex z) {
	Complex z1=map0(q,a0,a1,z);
	z1=map0(q,a0,a1,z1);
	return(z1);
    }

    /**for kites we have a1=a2.  Our formulas allow for the
       more general situation a1!=a2. This gives a mroe general system*/

    /**get the R parameters for the QTC*/
    public static double[] getR(double a1,double a2) {
	double b=(1+a1)/(1-a1);
	double c=(1+a2)/(1-a2);
	double d=b*b/(c*c-1);
	double[] r={1,b,d,b};
	return(r);
    }

    /**Get the shear parameters*/
    public static double[] getS(double a1,double a2) {
	double b=(1+a1)/(1-a1);
	double c=(1+a2)/(1-a2);
	double d=b*b/(c*c-1);
	double[] s={c,c*d,c*d,c};
	return(s);
    }


    public static Complex map0(int[] q,double a1,double a2,Complex z) {
	Complex z0=new Complex(z);
	double[] r=getR(a1,a2);
	double[] s=getS(a1,a2);
	return(QTCGeneral.QTC(q,r,s,z));
    }

    public static double[][] mapPosition(int[] q,double a1,double a2,Complex z) {
	double[] r=getR(a1,a2);
	double[] s=getS(a1,a2);
	return(QTCGeneral.mapPosition(q,r,s,z));
    }

    public static int[] graphRaw(int[] q,double a1,double a2,Complex z) {
	double[] r=getR(a1,a2);
	double[] s=getS(a1,a2);
	int[] Q=QTCGeneral.graph(q,r,s,z);
        return(Q);
    }

    public static int[] graph(int[] q,double a1,double a2,Complex z) {
        int[] Q=graphRaw(q,a1,a2,z);
	int x=Q[1]+Q[2]+Q[3];
	int y=Q[2];
	int[] X={-x,-y};
	return(X);
    }

    public static int[] graph2(int[] q,double a1,double a2,Complex z) {
        int[] Q=graphRaw(q,a1,a2,z);
	int x=-2*Q[0]-2*Q[1]-Q[2];
	int y=-Q[2];
	int[] X={-x,-y};
	return(X);
    }

}

